/*
  	#[ Includes :

	File contains the command routines for the FORM shell that was built
	to process large numbers of graphs. It should be easy to modify this
	for other projects.
	Note: the folding lines with the #[ and the #] work really well with
	the stedi editor by the same author.
	File made by J.Vermaseren.
*/

#include "manage.h"

#define ENDCODE 1357924680
#define INSIZE 257
FILE *inhandle;
char inbuffer[INSIZE+2];
int numprocessors = 0;

#ifdef UNIX
PINFO *processes = 0;
#endif

int DoEnd(char *in);
int DoInput(char *in);
int DoOutput(char *in);
int DoTouch(char *in);
int DoMake(char *in);
int DoMerge(char *in);
int DoShow(char *in);
int DoLoad(char *in);
int DoSystem(char *in);
int DoSum(char *in);
int DoSpecial(char *in);
int DoLinSum(char *in);

CFUNCTION cfunctions[] = {
	 {"end",           DoEnd}
	,{"input",         DoInput}
	,{"output",        DoOutput}
	,{"touch",         DoTouch}
	,{"show",          DoShow}
	,{"load",          DoLoad}
	,{"system",        DoSystem}
	,{"sum",           DoSum}
	,{"special",       DoSpecial}
	,{"make",          DoMake}
	,{"merge",         DoMerge}
	,{"linsum",        DoLinSum}
};

DBASE *dbases[MAXBASES];
int numdbases;
int withoutflush = 0;

/*
  	#] Includes :
  	#[ SkipString :
*/

char *SkipString(char *s)
{
	s++;
	while ( *s && *s != '"' && *s != '\n' ) {
		if ( *s == '\\' ) s++;
		s++;
	}
	if ( *s == 0 ) return(0);
	else return(s);
}

/*
  	#] SkipString :
  	#[ FindDbase :
*/

DBASE *FindDbase(char *name)
{
	int i;
	for ( i = 0; i < numdbases; i++ ) {
		if ( strcmp(dbases[i]->name,name) == 0 ) return(dbases[i]);
	}
	return(0);
}

/*
  	#] FindDbase :
  	#[ initialize :
*/

int initialize(void)
{
	return(0);
}

/*
  	#] initialize :
  	#[ finalize :
*/

int finalize(void)
{
	return(0);
}

/*
  	#] finalize :
  	#[ GetArgs :
*/

int GetArgs(char *in,char ***argv,char ***argval)
{
	char *s  = in, *t;
	int num = 0, new = 1;
	while ( *s ) {
		if ( *s == ',' || *s == ' ' || *s == '\t' ) new = 1;
		else if ( *s == '=' ) {
			if ( new ) { num++; new = 0; }
		}
		s++;
	}
	if ( ( *argv = (char **)mmalloc((num+1)*sizeof(char *),"list of keywords") )
	== 0 ) return(-1);
	if ( ( *argval = (char **)mmalloc((num+1)*sizeof(char *),"list of keywords") )
	== 0 ) { free(argv); return(-1); }
	num = 0; s = in;
	goto newarg;
	while ( *s ) {
		if ( *s == ',' || *s == ' ' || *s == '\t' ) {
newarg:		new = 1;
			while ( *s == ',' || *s == ' ' || *s == '\t' ) s++;
			(*argv)[num] = s;
			if ( num > 0 ) {
				t = s-1;
				while ( ( t >= (*argval)[num-1] ) &&
					( *t == ',' || *t == ' ' || *t == '\t' ) ) t--;
				t++;
				if ( *t != '=' ) *t = 0;
			}
		}
		else if ( *s == '=' ) {
			*s++ = 0;
			if ( new ) {
				while ( *s == ' ' || *s == '\t' ) s++;
				(*argval)[num] = s;
				num++; new = 0;
			}
		}
		else s++;
	}
	if ( num > 0 ) {
		t = s-1;
		while ( ( t >= (*argval)[num-1] ) &&
			( *t == ',' || *t == ' ' || *t == '\t' ) ) t--;
		t[1] = 0;
	}
	(*argv)[num] = (*argval)[num] = 0;
	return(0);
}

/*
  	#] GetArgs :
  	#[ Folds :
*/

char *findopen(char *s, char **name, char **nameend)
{
	char *t, *u;
	while ( *s ) {
		if ( *s == '\\' && s[1] ) { s += 2; continue; }
		else if ( *s != '\n' ) { s++; continue; }
		s++;
		if ( s[0] && s[0] != '\n' && s[1] && s[1] != '\n'
		&& s[2] && s[2] != '\n' && s[3] == '#' && s[4] == '[' ) {
			t = s+5;
			while ( *t && *t != '\n' && *t != ':' ) t++;
			if ( *t == ':' ) {
				s += 5;
				while ( *s == ' ' || *s == '\t' ) s++;
				u = t;
				while ( u > s && ( u[-1] == ' ' ||
				u[-1] == '\t' ) ) u--;
				if ( u > s ) {
					*name = s; *nameend = u;
					while ( *t && *t != '\n' ) {
						if ( *t == '\\' && t[1] ) t++;
						t++;
					}
					if ( *t == '\n' ) t++;
					return(t);
				}
			}
			s = t+1;
		}
		else s++;
	}
	return(0);
}

char *findclose(char *s, char *name, char *nameend)
{
	char *t, *u;
	while ( *s ) {
		if ( *s == '\\' && s[1] ) { s += 2; continue; }
		else if ( *s != '\n' ) { s++; continue; }
		s++;
		if ( s[0] && s[0] != '\n' && s[1] && s[1] != '\n'
		&& s[2] && s[2] != '\n' && s[3] == '#' && s[4] == ']' ) {
			t = s+5;
			while ( *t == ' ' || *t == '\t' ) t++;
			u = name;
			while ( u < nameend && *t == *u ) { t++; u++; }
			if ( u == nameend ) {
				while ( *t == ' ' || *t == '\t' ) t++;
				if ( *t == ':' ) return(s);
			}
			s = t;
		}
		else s++;
	}
	return(0);
}

int dofolds(DBASE *d,char *s,char *varname)
{
	char *name, *nameend, *t, c;
	int error;
	while ( ( s = findopen(s,&name,&nameend) ) != 0 ) {
		if ( ( t = findclose(s-1,name,nameend) ) != 0 ) {
			c = *nameend; *nameend = 0;
			error = handlefold(d,s,t,name,varname);
			*nameend = c;
			if ( error ) return(error);
			s--;
		}
		else s--; 	/* We need the '\n' to see the fold */
	}
	return(0);
}

/*
  	#] Folds :
  	#[ DoEnd :
*/

int DoEnd(char *in)
{
	return(ENDCODE);
}

/*
  	#] DoEnd :
  	#[ DoInput :
*/

int DoInput(char *in)
{
	char *s;
	int i;
	DBASE *d;
	s = in++;
	if ( *s != '"' || ( s = SkipString(s) ) == 0 ) {
syntax: printf("Syntax error in input statement\n");
		return(-1);
	}
	*s++ = 0;
	while ( *s == ' ' || *s == '\t' ) s++;
	if ( *s && *s != '\n' ) goto syntax;
	for ( i = 0; i < numdbases; i++ ) {
		if ( strcmp(in,dbases[i]->name) == 0 ) break;
	}
	if ( i >= numdbases ) { /* new database */
		if ( numdbases >= MAXBASES-1 ) {
			printf("-->More than %d databases\n",MAXBASES);
			return(-1);
		}
		if ( ( d = OpenDbase(in) ) == 0 ) return(-1);
		dbases[numdbases++] = d;
		d->mode = INPUTONLY;
	}
	else {
		d = dbases[i];
		if ( d->mode == OUTPUTONLY ) d->mode = INANDOUT;
	}
	return(0);
}

/*
  	#] DoInput :
  	#[ DoLoad :

	Loads the contents of a file into a database
	Load "into" "from" "ITEMNAME" "itemseparation"
*/

int DoLoad(char *in)
{
	char *s, *name, *itemname, *itemseparation = 0, c, *inbuffer;
	char **argv, **margv, *nargv[3], *t2, *s1, *s2, *item;
	DBASE *d;
	LONG num, filesize;
	int namesize, error, i, foldflag = 0;
	FILE *f = 0;
	name = in+1;
	if ( *in != '"' || ( in = SkipString(in) ) == 0 ) goto syntax;
	*in = 0;
	if ( ( d = FindDbase(name) ) == 0 ) {
		printf("There is no open database with the name %s\n",name);
		return(-1);
	}
	in++;
	while ( *in  == ' ' || *in == '\t' || *in == ',' ) in++;
	name = in+1;
	if ( *in != '"' || ( in = SkipString(in) ) == 0 ) goto syntax;
	*in = 0;
	if ( ( f = fopen(name,"r") ) == 0 ) {
		printf("Cannot open file %s\n",name);
		return(-1);
	}
	in++;
	while ( *in  == ' ' || *in == '\t' || *in == ',' ) in++;
	itemname = in+1;
	if ( *in != '"' || ( in = SkipString(in) ) == 0 ) goto syntax;
	*in = 0;
	namesize = in - itemname;
	in++;
	while ( *in  == ' ' || *in == '\t' || *in == ',' ) in++;
	if ( *in == '"' ) {
		itemseparation = in+1; in = SkipString(in);
		if ( in == 0 ) goto syntax;
		*in = 0;
	} else {
		s1 = in;
		while ( isalnum(*in) ) {
			*in = tolower(*in);
			in++;
		}
		c = *in; *in = 0;
		if ( strcmp(s1,"fold") == 0 ) foldflag = 1;
		else goto syntax;
		*in = c;
	}

	fseek(f,0,SEEK_END);
	filesize = ftell(f);
	if ( ( inbuffer = (char *)mmalloc(filesize+namesize+2,"input buffer") ) == 0 ) {
		fclose(f); return(-1);
	}
	fseek(f,0,SEEK_SET);
	if ( mread(f,inbuffer+namesize+1,filesize) ) {
		printf("Error while reading file %s\n",name);
		fclose(f); return(-1);
	}
	fclose(f);
	inbuffer[filesize] = 0;
	s = inbuffer+namesize+1;
	num = 0;
	withoutflush = 1;
	if ( foldflag == 0 ) {
		item = s;
		while ( *s ) {
		if ( *s == *itemseparation ) {
			s1 = s+1; s2 = itemseparation+1;
			while ( *s1 == *s2 ) { s1++; s2++; }
			if ( *s2 == 0 ) {
				if ( s > item ) {
newitem:
					c = *s; *s = 0;
					t2 = itemname; s2 = item-namesize-1;
					while ( *t2 ) *s2++ = *t2++;
					*s2 = '=';
					if ( num < d->info.entriesinindex
					&& ( argv = ReadObject(d,num) ) != 0 ) {
						if ( ( s2 = GetSubString(itemname,argv) ) != 0 ) {
							for ( i = 0;; i++ ) {
								if ( s2 == argv[i] ) break;
							}
							argv[i] = item-namesize-1;
						}
						else {
							i = 0;
							while ( argv[i] ) i++;
							margv = mmalloc(sizeof(char *)*(i+2),"string copy");
							if ( margv == 0 ) {
								fflush(f); withoutflush = 0;
								free(argv[0]); free(argv); free(inbuffer);
								fclose(f); return(-1);
							}
							i = 0;
							while ( argv[i] ) { margv[i] = argv[i]; }
							margv[i] = item-namesize-1;
							margv[i+1] = 0;
							free(argv);
							argv = margv;
						}
						error = WriteObject(d,argv,num);
						free(argv[0]); free(argv);
						if ( error ) {
							fflush(f); withoutflush = 0;
							free(inbuffer); fclose(f); return(-1);
						}
					}
					else {
						nargv[1] = item-namesize-1;
						nargv[2] = 0;
						if ( num < d->info.entriesinindex ) {
							if ( AddObject(d,nargv) < 0 ) {
								fflush(f); withoutflush = 0;
								free(inbuffer); fclose(f); return(-1);
							}
						}
						else if ( WriteObject(d,nargv,num) ) {
							fflush(f); withoutflush = 0;
							free(inbuffer); fclose(f); return(-1);
						}
					}
					*s = c;
					num++;
				}
			}
			item = s = s1;
		}
		else s++;
		}
		if ( s > item ) { s1 = s; goto newitem; }
		error = 0;
	}
	else { error = dofolds(d,s,itemname); }
	withoutflush = 0;
/*	fflush(f); */
/*	fclose(f); */
	free(inbuffer);
	return(error);
syntax:
	printf("Syntax error in load statement\n");
	if ( f ) fclose(f);
	return(-1);
}

/*
  	#] DoLoad :
  	#[ DoOutput :
*/

int DoOutput(char *in)
{
	char *s;
	int i;
	DBASE *d;
	s = in++;
	if ( *s != '"' || ( s = SkipString(s) ) == 0 ) {
syntax: printf("Syntax error in output statement\n");
		return(-1);
	}
	*s++ = 0;
	while ( *s == ' ' || *s == '\t' ) s++;
	if ( *s && *s != '\n' ) goto syntax;
	for ( i = 0; i < numdbases; i++ ) {
		if ( strcmp(in,dbases[i]->name) == 0 ) break;
	}
	if ( i >= numdbases ) {
		if ( numdbases >= MAXBASES-1 ) {
			printf("-->More than %d databases\n",MAXBASES);
			return(-1);
		}
		if ( ( d = GetDbase(in) ) == 0 ) return(-1);
		dbases[numdbases++] = d;
		d->mode = OUTPUTONLY;
	}
	else {
		d = dbases[i];
		if ( d->mode == INPUTONLY ) d->mode = INANDOUT;
	}
	return(0);
}

/*
  	#] DoOutput :
  	#[ DoSystem :
*/

int DoSystem(char *in)
{
	return(system(in));
}

/*
  	#] DoSystem :
  	#[ DoSum :

	Steps through all indicated objects.
	What we do with them is up to the routines SumStart, SumStep and SumFinish

*/

int DoSum(char *in)
{
	DBASE *d;
	char **argv, **argval, **dargv, **a, **b, *s, *t, *name, *outname;
	LONG i, imin, imax;
	int variety, error = 0;
	if ( *in <= '9' && *in >= '0' ) {
		variety = *in++ - '0';
		while ( *in >= '0' && *in <= '9' ) variety = 10*variety + *in++ -'0';
		while ( *in  == ' ' || *in == '\t' || *in == ',' ) in++;
	}
	else variety = -1;
	name = in + 1;
	if ( *in != '"' || ( in = SkipString(in) ) == 0 ) goto syntax;
	*in = 0;
	if ( ( d = FindDbase(name) ) == 0 ) {
		printf("There is no open database with the name %s\n",name);
		return(-1);
	}
	in++;
	while ( *in  == ' ' || *in == '\t' || *in == ',' ) in++;
	if ( *in == '"' ) {
		outname = in + 1;
		if ( ( in = SkipString(in) ) == 0 ) goto syntax;
		*in++ = 0;
		while ( *in  == ' ' || *in == '\t' || *in == ',' ) in++;
	}
	else outname = 0;
	imin = 0; imax = d->info.entriesinindex;
	if ( *in == '[' ) {
		in++;
		while ( *in  == ' ' || *in == '\t' || *in == ',' ) in++;
		if ( *in >= '0' && *in <= '9' ) {
			while ( *in >= '0' && *in <= '9' ) imin = 10*imin + *in++ - '0';
			while ( *in  == ' ' || *in == '\t' || *in == ',' ) in++;
		}
		if ( *in != '-' ) goto syntax;
		in++;
		while ( *in  == ' ' || *in == '\t' || *in == ',' ) in++;
		if ( *in >= '0' && *in <= '9' ) {
			imax = 0;
			while ( *in >= '0' && *in <= '9' ) imax = 10*imax + *in++ - '0';
			while ( *in  == ' ' || *in == '\t' || *in == ',' ) in++;
		}
		if ( *in != ']' ) goto syntax;
		imin--;
		in++;
		while ( *in  == ' ' || *in == '\t' || *in == ',' ) in++;
		if ( imax > d->info.entriesinindex ) imax = d->info.entriesinindex;
	}
	if ( GetArgs(in,&argv,&argval) ) return(-1);
	if ( SumStart(variety,outname) == 0 ) {
		for ( i = imin; i < imax; i++ ) {
			if ( ( dargv = ReadObject(d,i) ) == 0 ) continue;
			a = argv; b = argval;
			while ( *a ) {
				s = GetSubString(*a,dargv);
				if ( s == 0 ) break;
				while ( *s == ' ' || *s == '\t' ) s++;
				t = *b;
				while ( *t && *s == *t ) { s++; t++; }
				while ( *s == ' ' || *s == '\t' ) s++;
				if ( *t || *s ) break;
				a++; b++;
			}
			if ( *a == 0 ) {	/* match */
				if ( SumStep(variety,dargv,i,outname) ) {
					free(dargv[0]); free(dargv);
					free(argv); free(argval);
					return(-1);
				}
			}
			free(dargv[0]); free(dargv);
		}
		if ( SumFinish(variety,outname) ) error = -1;
	}
	else error = -1;
	free(argv); free(argval);
	return(error);
syntax:
	printf("Syntax error in sum statement\n");
	return(-1);
}

/*
  	#] DoSum :
  	#[ DoSpecial :

	Steps through all indicated objects.
	What we do with them is up to the routines SumStart, SpecStep and SumFinish

*/

int DoSpecial(char *in)
{
	DBASE *d1, *d2;
	char **argv, **argval, **dargv1, **dargv2, **a, **b, *s, *t, *name, *outname;
	LONG i, imin, imax;
	int variety, error = 0;
	if ( *in <= '9' && *in >= '0' ) {
		variety = *in++ - '0';
		while ( *in >= '0' && *in <= '9' ) variety = 10*variety + *in++ -'0';
		while ( *in  == ' ' || *in == '\t' || *in == ',' ) in++;
	}
	else variety = -1;
	name = in + 1;
	if ( *in != '"' || ( in = SkipString(in) ) == 0 ) goto syntax;
	*in = 0;
	if ( ( d1 = FindDbase(name) ) == 0 ) {
		printf("There is no open database with the name %s\n",name);
		return(-1);
	}
	in++;
	while ( *in  == ' ' || *in == '\t' || *in == ',' ) in++;
	name = in + 1;
	if ( *in != '"' || ( in = SkipString(in) ) == 0 ) goto syntax;
	*in = 0;
	if ( ( d2 = FindDbase(name) ) == 0 ) {
		printf("There is no open database with the name %s\n",name);
		return(-1);
	}
	in++;
	while ( *in  == ' ' || *in == '\t' || *in == ',' ) in++;
	if ( *in == '"' ) {
		outname = in + 1;
		if ( ( in = SkipString(in) ) == 0 ) goto syntax;
		*in++ = 0;
		while ( *in  == ' ' || *in == '\t' || *in == ',' ) in++;
	}
	else outname = 0;
	imin = 0; imax = d1->info.entriesinindex;
	if ( *in == '[' ) {
		in++;
		while ( *in  == ' ' || *in == '\t' || *in == ',' ) in++;
		if ( *in >= '0' && *in <= '9' ) {
			while ( *in >= '0' && *in <= '9' ) imin = 10*imin + *in++ - '0';
			while ( *in  == ' ' || *in == '\t' || *in == ',' ) in++;
		}
		if ( *in != '-' ) goto syntax;
		in++;
		while ( *in  == ' ' || *in == '\t' || *in == ',' ) in++;
		if ( *in >= '0' && *in <= '9' ) {
			imax = 0;
			while ( *in >= '0' && *in <= '9' ) imax = 10*imax + *in++ - '0';
			while ( *in  == ' ' || *in == '\t' || *in == ',' ) in++;
		}
		if ( *in != ']' ) goto syntax;
		imin--;
		in++;
		while ( *in  == ' ' || *in == '\t' || *in == ',' ) in++;
		if ( imax > d1->info.entriesinindex ) imax = d1->info.entriesinindex;
	}
	if ( GetArgs(in,&argv,&argval) ) return(-1);
	if ( SumStart(variety,outname) == 0 ) {
		for ( i = imin; i < imax; i++ ) {
			if ( ( dargv1 = ReadObject(d1,i) ) == 0 ) continue;
			if ( ( dargv2 = ReadObject(d2,i) ) == 0 ) continue;
			a = argv; b = argval;
			while ( *a ) {
				s = GetSubString(*a,dargv1);
				if ( s == 0 ) break;
				while ( *s == ' ' || *s == '\t' ) s++;
				t = *b;
				while ( *t && *s == *t ) { s++; t++; }
				while ( *s == ' ' || *s == '\t' ) s++;
				if ( *t || *s ) break;
				a++; b++;
			}
			if ( *a == 0 ) {	/* match */
				if ( SpecStep(variety,dargv1,dargv2,i,outname) ) {
					free(dargv1[0]); free(dargv1);
					free(dargv2[0]); free(dargv2);
					free(argv); free(argval);
					return(-1);
				}
			}
			free(dargv1[0]); free(dargv1);
			free(dargv2[0]); free(dargv2);
		}
		if ( SumFinish(variety,outname) ) error = -1;
	}
	else error = -1;
	free(argv); free(argval);
	return(error);
syntax:
	printf("Syntax error in special statement\n");
	return(-1);
}

/*
  	#] DoSpecial :
  	#[ DoLinSum :

	Steps through all indicated objects.
	What we do with them is up to the routines LinSumStart,
	LinSumStep and SumFinish

*/

int DoLinSum(char *in)
{
	DBASE *d;
	char **argv, **argval, **dargv, **a, **b, *s, *t, *name, *outname;
	LONG i, imin, imax;
	int variety, error = 0;
	if ( *in <= '9' && *in >= '0' ) {
		variety = *in++ - '0';
		while ( *in >= '0' && *in <= '9' ) variety = 10*variety + *in++ -'0';
		while ( *in  == ' ' || *in == '\t' || *in == ',' ) in++;
	}
	else variety = -1;
	name = in + 1;
	if ( *in != '"' || ( in = SkipString(in) ) == 0 ) goto syntax;
	*in = 0;
	if ( ( d = FindDbase(name) ) == 0 ) {
		printf("There is no open database with the name %s\n",name);
		return(-1);
	}
	in++;
	while ( *in  == ' ' || *in == '\t' || *in == ',' ) in++;
	if ( *in == '"' ) {
		outname = in + 1;
		if ( ( in = SkipString(in) ) == 0 ) goto syntax;
		*in++ = 0;
		while ( *in  == ' ' || *in == '\t' || *in == ',' ) in++;
	}
	else outname = 0;
	imin = 0; imax = d->info.entriesinindex;
	if ( *in == '[' ) {
		in++;
		while ( *in  == ' ' || *in == '\t' || *in == ',' ) in++;
		if ( *in >= '0' && *in <= '9' ) {
			while ( *in >= '0' && *in <= '9' ) imin = 10*imin + *in++ - '0';
			while ( *in  == ' ' || *in == '\t' || *in == ',' ) in++;
		}
		if ( *in != '-' ) goto syntax;
		in++;
		while ( *in  == ' ' || *in == '\t' || *in == ',' ) in++;
		if ( *in >= '0' && *in <= '9' ) {
			imax = 0;
			while ( *in >= '0' && *in <= '9' ) imax = 10*imax + *in++ - '0';
			while ( *in  == ' ' || *in == '\t' || *in == ',' ) in++;
		}
		if ( *in != ']' ) goto syntax;
		imin--;
		in++;
		while ( *in  == ' ' || *in == '\t' || *in == ',' ) in++;
		if ( imax > d->info.entriesinindex ) imax = d->info.entriesinindex;
	}
	if ( GetArgs(in,&argv,&argval) ) return(-1);

	if ( LinSumStart(-1,outname) == 0 ) {
		for ( i = imin; i < imax; i++ ) {
			if ( ( dargv = ReadObject(d,i) ) == 0 ) continue;
			a = argv; b = argval;
			while ( *a ) {
				s = GetSubString(*a,dargv);
				if ( s == 0 ) break;
				while ( *s == ' ' || *s == '\t' ) s++;
				t = *b;
				while ( *t && *s == *t ) { s++; t++; }
				while ( *s == ' ' || *s == '\t' ) s++;
				if ( *t || *s ) break;
				a++; b++;
			}
			if ( *a == 0 ) {	/* match */
				if ( LinSumDecl(variety,dargv,i,outname) ) {
					free(dargv[0]); free(dargv);
					free(argv); free(argval);
					return(-1);
				}
			}
			free(dargv[0]); free(dargv);
		}
	}
	else {
		error = -1;
		free(argv); free(argval);
		return(error);
	}

	if ( LinSumStart(variety,outname) == 0 ) {
		for ( i = imin; i < imax; i++ ) {
			if ( ( dargv = ReadObject(d,i) ) == 0 ) continue;
			a = argv; b = argval;
			while ( *a ) {
				s = GetSubString(*a,dargv);
				if ( s == 0 ) break;
				while ( *s == ' ' || *s == '\t' ) s++;
				t = *b;
				while ( *t && *s == *t ) { s++; t++; }
				while ( *s == ' ' || *s == '\t' ) s++;
				if ( *t || *s ) break;
				a++; b++;
			}
			if ( *a == 0 ) {	/* match */
				if ( LinSumStep(variety,dargv,i,outname) ) {
					free(dargv[0]); free(dargv);
					free(argv); free(argval);
					return(-1);
				}
			}
			free(dargv[0]); free(dargv);
		}
		if ( LinSumFinish(variety,outname) ) error = -1;
	}
	else error = -1;
	free(argv); free(argval);
	return(error);
syntax:
	printf("Syntax error in sum statement\n");
	return(-1);
}

/*
  	#] DoLinSum :
  	#[ DoShow :

	show "filename" [\[[min]-[max]\]] [@] [(VAR1,VAR2,...,VARN)] [{NAME=VAL,}]
*/

int DoShow(char *in)
{
	DBASE *d;
	char **argv, **argval, **dargv, **a, **b, **pargv = 0, *s, *t, *name;
	LONG i, imin, imax;
	int num, dateflag = 0;
	name = in+1;
	if ( *in != '"' || ( in = SkipString(in) ) == 0 ) goto syntax;
	*in = 0;
	if ( ( d = FindDbase(name) ) == 0 ) {
		printf("There is no open database with the name %s\n",name);
		return(-1);
	}
	in++;
	while ( *in  == ' ' || *in == '\t' || *in == ',' ) in++;
	if ( *in == 0 ) return(DumpContents(d,0,0,d->info.entriesinindex));

	imin = 0; imax = d->info.entriesinindex;
	if ( *in == '[' ) {
		in++;
		while ( *in  == ' ' || *in == '\t' || *in == ',' ) in++;
		if ( *in >= '0' && *in <= '9' ) {
			while ( *in >= '0' && *in <= '9' ) imin = 10*imin + *in++ - '0';
			while ( *in  == ' ' || *in == '\t' || *in == ',' ) in++;
		}
		if ( *in != '-' ) goto syntax;
		in++;
		while ( *in  == ' ' || *in == '\t' || *in == ',' ) in++;
		if ( *in >= '0' && *in <= '9' ) {
			imax = 0;
			while ( *in >= '0' && *in <= '9' ) imax = 10*imax + *in++ - '0';
			while ( *in  == ' ' || *in == '\t' || *in == ',' ) in++;
		}
		if ( *in != ']' ) goto syntax;
		imin--;
		in++;
		while ( *in  == ' ' || *in == '\t' || *in == ',' ) in++;
		if ( imax > d->info.entriesinindex ) imax = d->info.entriesinindex;
	}
	if ( *in == '@' ) {
		dateflag = 1; in++;
		while ( *in  == ' ' || *in == '\t' || *in == ',' ) in++;
	}
	if ( *in == '(' ) {
		in++;
		while ( *in == ' ' || *in == '\t' || *in == ',' ) in++;
		s = in; num = 0;
		while ( *s && *s != ')' ) {
			if ( *s == ',' ) num++;
			s++;
		}
		if ( *s == 0 ) goto syntax;
		pargv = (char **)mmalloc((num+2)*sizeof(char *),"object names");
		if ( pargv == 0 ) goto endf;
		a = pargv; s = in;
		*a++ = s;
		while ( *s && *s != ')' ) {
			if ( *s == ',' ) {
				t = s-1;
				while ( t >= a[-1] && ( *t == ' ' || *t == '\t' ) ) t--;
				t[1] = 0; s++;
				while ( *s == ' ' || *s == '\t' ) s++;
				*a++ = s;
			}
			else s++;
		}
		t = s-1;
		while ( t >= a[-1] && ( *t == ' ' || *t == '\t' ) ) t--;
		t[1] = 0; *a = 0;
		s++; in = s;
	}
	if ( GetArgs(in,&argv,&argval) ) goto endf;
	for ( i = imin; i < imax; i++ ) {
		if ( ( dargv = ReadObject(d,i) ) == 0 ) continue;
		a = argv; b = argval;
		while ( *a ) {
			s = GetSubString(*a,dargv);
			if ( s == 0 ) break;
			while ( *s == ' ' || *s == '\t' ) s++;
			t = *b;
			while ( *t && *s == *t ) { s++; t++; }
			while ( *s == ' ' || *s == '\t' ) s++;
			if ( *t || *s ) break;
			a++; b++;
		}
		if ( *a == 0 ) {	/* match */
			a = dargv+1;
			printf("%ld:\n",i+1);
			if ( dateflag ) printf(" DATE= %s",ctime(
			&(d->iblocks[i/NUMOBJECTS]->objects[i%NUMOBJECTS].date)));
			while ( *a ) {
				if ( pargv ) {
					b = pargv;
					while ( *b ) {
						s = *a; t = *b;
						while ( *t && *s == *t ) { s++; t++; }
						while ( *s == ' ' || *s == '\t' ) s++;
						if ( *t == 0 && *s == '=' ) break;
						b++;
					}
					if ( *b ) {
						char *aa, *bb, c;
						int num;
						aa = *a;
						do {
							num = 0; bb = aa;
							while ( *aa && num < 75 ) { num++; aa++; }
							if ( *aa ) {
								c = *aa; *aa = 0;
								printf(" %s\\\n",bb);
								*aa = c;
							}
							else printf(" %s\n",bb);
						} while ( *aa );
					}
				}
				else {
					char *aa, *bb, c;
					aa = *a;
					while ( *aa ) {
						num = 0;
						bb = aa;
						while ( ( *aa != 0 ) && ( num < 75 ) ) { aa++; num++; }
						if ( *aa ) {
							c = *aa; *aa = 0;
							printf(" %s\\\n",bb);
							*aa = c;
						}
						else printf(" %s\n",bb);
					}
				}
				a++;
			}
		}
		free(dargv[0]); free(dargv);
	}
	free(argv); free(argval);
	return(0);
syntax:
	printf("Syntax error in show statement\n");
endf:
	if ( pargv ) free(pargv);
	return(-1);
}

/*
  	#] DoShow :
  	#[ DoTouch :

	touch "filename" [\[[min]-[max]\]] [{NAME=VAL,}]
*/

int DoTouch(char *in)
{
	DBASE *d;
	char **argv, **argval, **dargv, **a, **b, *s, *t, *name;
	LONG i, imin, imax;
	int error;
	name = in+1;
	if ( *in != '"' || ( in = SkipString(in) ) == 0 ) goto syntax;
	*in = 0;
	if ( ( d = FindDbase(name) ) == 0 ) {
		printf("There is no open database with the name %s\n",name);
		return(-1);
	}
	in++;
	while ( *in  == ' ' || *in == '\t' || *in == ',' ) in++;
	if ( *in == 0 ) return(DumpContents(d,0,0,d->info.entriesinindex));

	imin = 0; imax = d->info.entriesinindex;
	if ( *in == '[' ) {
		in++;
		while ( *in  == ' ' || *in == '\t' || *in == ',' ) in++;
		if ( *in == 'a' && in[1] == 'l' && in[2] == 'l' ) {
			in += 3;
			while ( *in  == ' ' || *in == '\t' || *in == ',' ) in++;
			if ( *in != ']' ) goto syntax;
			imin = 0;
			imax = d->info.entriesinindex;
		}
		else {
			if ( *in >= '0' && *in <= '9' ) {
				while ( *in >= '0' && *in <= '9' ) imin = 10*imin + *in++ - '0';
				while ( *in  == ' ' || *in == '\t' || *in == ',' ) in++;
			}
			if ( *in != '-' ) goto syntax;
			in++;
			while ( *in  == ' ' || *in == '\t' || *in == ',' ) in++;
			if ( *in >= '0' && *in <= '9' ) {
				imax = 0;
				while ( *in >= '0' && *in <= '9' ) imax = 10*imax + *in++ - '0';
				while ( *in  == ' ' || *in == '\t' || *in == ',' ) in++;
			}
			if ( *in != ']' ) goto syntax;
			imin--;
			in++;
			while ( *in  == ' ' || *in == '\t' || *in == ',' ) in++;
			if ( imax > d->info.entriesinindex ) imax = d->info.entriesinindex;
		}
	}
	if ( GetArgs(in,&argv,&argval) ) return(-1);
	for ( i = imin; i < imax; i++ ) {
		if ( ( dargv = ReadObject(d,i) ) == 0 ) continue;
		a = argv; b = argval;
		while ( *a ) {
			s = GetSubString(*a,dargv);
			if ( s == 0 ) break;
			while ( *s == ' ' || *s == '\t' ) s++;
			t = *b;
			while ( *t && *s == *t ) { s++; t++; }
			while ( *s == ' ' || *s == '\t' ) s++;
			if ( *t || *s ) break;
			a++; b++;
		}
		if ( *a == 0 ) {	/* match */
			d->iblocks[i/NUMOBJECTS]->objects[i%NUMOBJECTS].date = time(0);
			d->iblocks[i/NUMOBJECTS]->flags |= DIRTYFLAG;
		}
		free(dargv[0]); free(dargv);
	}
	free(argv); free(argval);
	error = 0;
	for ( i = 0; i < d->info.numberofindexblocks; i++ ) {
		if ( ( d->iblocks[i]->flags & DIRTYFLAG ) != 0 ) {
			if ( WriteIndexBlock(d,i) == 0 )
				d->iblocks[i]->flags &= CLEANFLAG;
			else error = -1;	/* Don't know how to repair */
		}
	}
	return(error);
syntax:
	printf("Syntax error in touch statement\n");
	return(-1);
}

/*
  	#] DoTouch :
  	#[ DoMake :

	make [variety] "infile" "outfile"(OUTVAR) [\[[min]-[max]\]] [{NAME=VAL,}]
*/

int DoMake(char *in)
{
	DBASE *din, *dout;
	char **argv, **argval;
	char *name, *outvar;
	char **dinargv, **doutargv, **a, **b;
	char *s, *t;
	LONG i, imin, imax, iinc, ii = 0;
	int variety, j;
	if ( numprocessors == 0 ) {
		outvar = getenv("MINOSPROCESSORS");
		if ( outvar == 0 ) numprocessors = 1;
		else {
			s = outvar;
			while ( *s >= '0' && *s <= '9' ) {
				numprocessors = 10*numprocessors + *s++ - '0';
			}
			if ( *s ) {
				printf("Environment variable MINOSPROCESSORS expected to be a number. It is: %s\n",
					outvar);
				numprocessors = 1;
			}
		}
#ifdef UNIX
		if ( numprocessors > 1 ) {
			processes = (PINFO *)mmalloc(numprocessors*sizeof(PINFO),"processors");
			for ( j = 0; j < numprocessors; j++ ) {
				processes[j].idnumber = 0;
				processes[j].basenumber = -1;
			}
		}
#else
		numprocessors = 1;
#endif
	}
	if ( *in <= '9' && *in >= '0' ) {
		variety = *in++ - '0';
		while ( *in >= '0' && *in <= '9' ) variety = 10*variety + *in++ -'0';
		while ( *in  == ' ' || *in == '\t' || *in == ',' ) in++;
	}
	else variety = -1;
	name = in+1;
	if ( *in != '"' || ( in = SkipString(in) ) == 0 ) goto syntax;
	*in++ = 0;
	if ( ( din = FindDbase(name) ) == 0 ) {
		printf("There is no open database with the name %s\n",name);
		return(-1);
	}
	while ( *in  == ' ' || *in == '\t' || *in == ',' ) in++;
	name = in+1;
	if ( *in != '"' || ( in = SkipString(in) ) == 0 ) goto syntax;
	*in++ = 0;
	if ( ( dout = FindDbase(name) ) == 0 ) {
		printf("There is no open database with the name %s\n",name);
		return(-1);
	}
	while ( *in  == ' ' || *in == '\t' || *in == ',' ) in++;
	if ( *in != '(' ) goto syntax;
	in++;
	while ( *in  == ' ' || *in == '\t' || *in == ',' ) in++;
	outvar = in;
	while ( *in && *in != ' ' && *in != '\t' && *in != ',' && *in != ')' ) in++;
	if ( *in == 0 ) goto syntax;
	if ( *in != ')' ) {
		*in++ = 0;
		while ( *in  == ' ' || *in == '\t' || *in == ',' ) in++;
		if ( *in != ')' ) goto syntax;
	}
	*in++ = 0;
	while ( *in == ' ' || *in == '\t' ) in++;

	imin = 0; imax = din->info.entriesinindex;
	if ( *in == '[' ) {
		in++;
		while ( *in  == ' ' || *in == '\t' || *in == ',' ) in++;
		if ( *in >= '0' && *in <= '9' ) {
			while ( *in >= '0' && *in <= '9' ) imin = 10*imin + *in++ - '0';
			while ( *in  == ' ' || *in == '\t' || *in == ',' ) in++;
		}
		if ( *in != '-' ) goto syntax;
		in++;
		while ( *in  == ' ' || *in == '\t' || *in == ',' ) in++;
		if ( *in >= '0' && *in <= '9' ) {
			imax = 0;
			while ( *in >= '0' && *in <= '9' ) imax = 10*imax + *in++ - '0';
			while ( *in  == ' ' || *in == '\t' || *in == ',' ) in++;
		}
		if ( *in != ']' ) goto syntax;
		in++;
		while ( *in  == ' ' || *in == '\t' || *in == ',' ) in++;
		if ( imax > din->info.entriesinindex ) imax = din->info.entriesinindex;
		if ( imin > din->info.entriesinindex ) imin = din->info.entriesinindex;
		imin--;
	}

	if ( GetArgs(in,&argv,&argval) ) return(-1);
	if ( dout->info.entriesinindex < imax ) {
		if ( AddToIndex(dout,imax-dout->info.entriesinindex) ) return(-1);
	}
	if ( dout->info.entriesinindex <= imin ) {
		if ( AddToIndex(dout,imin+1-dout->info.entriesinindex) ) return(-1);
	}
/*
	Now the loop
	For each element whose number is correct, test:
	a:	whether the args in pin are right (if specified)
	b:	whether the date is right, or
	c:	whether the outvar is present
*/
	if ( imax >= imin ) { iinc = 1; }
	else { imax = imax - 1; iinc = -1; }
#ifdef UNIX
	if ( variety != 0 || numprocessors <= 1 ) {
#endif
	  for ( i = imin; i != imax; i += iinc ) {
		if ( ( dinargv = ReadObject(din,i) ) == 0 ) continue;
		a = argv; b = argval;
		while ( *a ) {
			s = GetSubString(*a,dinargv);
			if ( s == 0 ) break;
			while ( *s == ' ' || *s == '\t' ) s++;
			t = *b;
			while ( *t && *s == *t ) { s++; t++; }
			while ( *s == ' ' || *s == '\t' ) s++;
			if ( *t || *s ) break;
			a++; b++;
		}
		if ( *a == 0 ) {	/* match */
			if ( ( doutargv = ReadObject(dout,i) ) == 0 ) {
				printf("Execution aborted due to error\n");
				return(-1);
			}
			if ( GetSubString(outvar,doutargv) == 0 ||
				din->iblocks[i/NUMOBJECTS]->objects[i%NUMOBJECTS].date >
				dout->iblocks[i/NUMOBJECTS]->objects[i%NUMOBJECTS].date ) {
				if ( RunMake(variety,dinargv,&doutargv,i,outvar,0) ) {
					return(-1);
				}
				if ( WriteObject(dout,doutargv,i) ) return(-1);
			}
			free(doutargv[0]); free(doutargv);
		}
		free(dinargv[0]);  free(dinargv);
	  }
#ifdef UNIX
	}
	else {
	  pid_t p;
	  int errorcode;
/*
		We come here if there is more than one processor and we run the 
		standard make variety=0 (form calcdia > calcdia.log)
*/
	  for ( i = imin; i != imax; i += iinc ) {
restartloop:;
		if ( ( dinargv = ReadObject(din,i) ) == 0 ) continue;
		for ( j = 0; j < numprocessors; j++ ) {
			if ( processes[j].basenumber < 0 ) break;
		}
		if ( j >= numprocessors ) { /* all processors occupied. wait. */
			p = wait(&errorcode);
			for ( j = 0; j < numprocessors; j++ ) {
				if ( processes[j].idnumber == p ) {
					ii = processes[j].basenumber;
					processes[j].idnumber = 0;
					processes[j].basenumber = -1;
					break;
				}
			}
			if ( j >= numprocessors ) {
				printf("Finished process is unknown\n");
				goto killchildren;
			}
			dinargv = ReadObject(din,ii);
			a = argv; b = argval;
			while ( *a ) {
				s = GetSubString(*a,dinargv);
				if ( s == 0 ) break;
				while ( *s == ' ' || *s == '\t' ) s++;
				t = *b;
				while ( *t && *s == *t ) { s++; t++; }
				while ( *s == ' ' || *s == '\t' ) s++;
				if ( *t || *s ) break;
				a++; b++;
			}
/*
			The match must exist!
*/
			doutargv = ReadObject(dout,ii);
			GetSubString(outvar,doutargv);
			if ( RunMake(variety,dinargv,&doutargv,ii,outvar,-j-1) ) {
				goto killchildren;
			}
			if ( WriteObject(dout,doutargv,ii) ) goto killchildren;
			free(doutargv[0]); free(doutargv);
			free(dinargv[0]);  free(dinargv);
			goto restartloop;
		}
		else {
/*
			We can start up a new process with internal number j
*/
			a = argv; b = argval;
			while ( *a ) {
				s = GetSubString(*a,dinargv);
				if ( s == 0 ) break;
				while ( *s == ' ' || *s == '\t' ) s++;
				t = *b;
				while ( *t && *s == *t ) { s++; t++; }
				while ( *s == ' ' || *s == '\t' ) s++;
				if ( *t || *s ) break;
				a++; b++;
			}
			if ( *a == 0 ) {	/* match */
				if ( ( doutargv = ReadObject(dout,i) ) == 0 ) {
					printf("Execution aborted due to error\n");
					return(-1);
				}
				if ( GetSubString(outvar,doutargv) == 0 ||
					din->iblocks[i/NUMOBJECTS]->objects[i%NUMOBJECTS].date >
					dout->iblocks[i/NUMOBJECTS]->objects[i%NUMOBJECTS].date ) {

					p = fork();
					if ( p < 0 ) {
						printf("Cannot start a new process with fork\n");
						goto killchildren;
					}
					else if ( p == 0 ) { /* child process */
						exit(RunMake(variety,dinargv,&doutargv,i,outvar,j+1));
					}
					else {	/* parent */
						processes[j].idnumber = p;
						processes[j].basenumber = i;
					}
				}
				free(doutargv[0]); free(doutargv);
			}
			free(dinargv[0]);  free(dinargv);
		}
	  }
/*
		Now we have to wait for the processes that still run.
*/
	  for (;;) {
		for ( j = 0; j < numprocessors; j++ ) {
			if ( processes[j].basenumber >= 0 ) break;
		}
		if ( j >= numprocessors ) break;  /* no more processes */
		{
			p = wait(&errorcode);
			for ( j = 0; j < numprocessors; j++ ) {
				if ( processes[j].idnumber == p ) {
					ii = processes[j].basenumber;
					processes[j].idnumber = 0;
					processes[j].basenumber = -1;
					break;
				}
			}
			if ( j >= numprocessors ) {
				printf("Finished process is unknown\n");
				goto killchildren;
			}
			dinargv = ReadObject(din,ii);
			a = argv; b = argval;
			while ( *a ) {
				s = GetSubString(*a,dinargv);
				if ( s == 0 ) break;
				while ( *s == ' ' || *s == '\t' ) s++;
				t = *b;
				while ( *t && *s == *t ) { s++; t++; }
				while ( *s == ' ' || *s == '\t' ) s++;
				if ( *t || *s ) break;
				a++; b++;
			}
/*
			The match must exist!
*/
			doutargv = ReadObject(dout,ii);
			GetSubString(outvar,doutargv);
			if ( RunMake(variety,dinargv,&doutargv,ii,outvar,-j-1) ) {
				goto killchildren;
			}
			if ( WriteObject(dout,doutargv,ii) ) goto killchildren;
			free(doutargv[0]); free(doutargv);
			free(dinargv[0]);  free(dinargv);
		}
	  }
	}
#endif
	free(argv); free(argval);
	return(0);
syntax:
	printf("Syntax error in make statement\n");
	return(-1);
#ifdef UNIX

killchildren:
	for ( j = 0; j < numprocessors; j++ ) {
		if ( processes[j].idnumber > 0 ) {
			kill(processes[j].idnumber,SIGTERM);
		}
	}
	return(-1);
#endif
}

/*
  	#] DoMake :
  	#[ DoMerge :

	merge "infile1" "infile2" "outfile"
*/

int DoMerge(char *in)
{
	DBASE *din1, *din2, *dout;
	char **dinargv1, **dinargv2, *name;
	LONG i, i1, i2, imax;
	name = in+1;
	if ( *in != '"' || ( in = SkipString(in) ) == 0 ) goto syntax;
	*in++ = 0;
	if ( ( din1 = FindDbase(name) ) == 0 ) {
		printf("There is no open database with the name %s\n",name);
		return(-1);
	}
	while ( *in  == ' ' || *in == '\t' || *in == ',' ) in++;
	name = in+1;
	if ( *in != '"' || ( in = SkipString(in) ) == 0 ) goto syntax;
	*in++ = 0;
	if ( ( din2 = FindDbase(name) ) == 0 ) {
		printf("There is no open database with the name %s\n",name);
		return(-1);
	}
	while ( *in  == ' ' || *in == '\t' || *in == ',' ) in++;
	name = in+1;
	if ( *in != '"' || ( in = SkipString(in) ) == 0 ) goto syntax;
	*in++ = 0;
	if ( ( dout = FindDbase(name) ) == 0 ) {
		printf("There is no open database with the name %s\n",name);
		return(-1);
	}
	while ( *in  == ' ' || *in == '\t' || *in == ',' ) in++;
	if ( *in && *in != '\n' ) goto syntax;

/*
	Now the loop
*/
	i1 = din1->info.entriesinindex;
	i2 = din2->info.entriesinindex;
	imax = i1; if ( i2 > imax ) imax = i2;
	if ( dout->info.entriesinindex < imax ) {
		if ( AddToIndex(dout,imax-dout->info.entriesinindex) ) return(-1);
	}
	for ( i = 0; i < i1 && i < i2; i++ ) {
		if ( ( dinargv1 = ReadObject(din1,i) ) == 0 ) {
			if ( ( dinargv2 = ReadObject(din2,i) ) == 0 ) continue;
take2:		if ( WriteObject(dout,dinargv2,i) ) return(-1);
			dout->iblocks[i/NUMOBJECTS]->objects[i%NUMOBJECTS].date =
				din2->iblocks[i/NUMOBJECTS]->objects[i%NUMOBJECTS].date;
			free(dinargv2[0]);  free(dinargv2);
		}
		else if ( ( dinargv2 = ReadObject(din2,i) ) == 0 ) {
take1:		if ( WriteObject(dout,dinargv1,i) ) return(-1);
			dout->iblocks[i/NUMOBJECTS]->objects[i%NUMOBJECTS].date =
				din1->iblocks[i/NUMOBJECTS]->objects[i%NUMOBJECTS].date;
			free(dinargv1[0]);  free(dinargv1);
		}
		else {
			if ( ( din2->iblocks[i/NUMOBJECTS]->objects[i%NUMOBJECTS].size > 0 )
			&& ( din1->iblocks[i/NUMOBJECTS]->objects[i%NUMOBJECTS].size > 0 )
			&& ( din2->iblocks[i/NUMOBJECTS]->objects[i%NUMOBJECTS].position >= 0 )
			&& ( din1->iblocks[i/NUMOBJECTS]->objects[i%NUMOBJECTS].position >= 0 ) ) {
				if ( din2->iblocks[i/NUMOBJECTS]->objects[i%NUMOBJECTS].date >=
					din1->iblocks[i/NUMOBJECTS]->objects[i%NUMOBJECTS].date ) {
					free(dinargv1[0]);  free(dinargv1);
					printf("Object %ld from %s skipped\n",i+1,din1->name);
					goto take2;
				}
				else {
					free(dinargv2[0]);  free(dinargv2);
					printf("Object %ld from %s skipped\n",i+1,din2->name);
					goto take1;
				}
			}
			else {
				if ( ( din2->iblocks[i/NUMOBJECTS]->objects[i%NUMOBJECTS].size > 0 )
				&& ( din2->iblocks[i/NUMOBJECTS]->objects[i%NUMOBJECTS].position >= 0 ) ) {
					free(dinargv1[0]);  free(dinargv1);
					goto take2;
				}
				if ( ( din1->iblocks[i/NUMOBJECTS]->objects[i%NUMOBJECTS].size > 0 )
				&& ( din1->iblocks[i/NUMOBJECTS]->objects[i%NUMOBJECTS].position >= 0 ) ) {
					free(dinargv2[0]);  free(dinargv2);
					goto take1;
				}
			}
		}
	}
	if ( i1 < i2 ) { din1 = din2; i = i1; i1 = i2; i2 = i; }
	if ( i1 != i2 ) {
		for ( i = i2; i < i1; i++ ) {
			if ( ( dinargv1 = ReadObject(din1,i) ) == 0 ) continue;
			if ( WriteObject(dout,dinargv1,i) ) return(-1);
			dout->iblocks[i/NUMOBJECTS]->objects[i%NUMOBJECTS].date =
				din1->iblocks[i/NUMOBJECTS]->objects[i%NUMOBJECTS].date;
			free(dinargv1[0]);  free(dinargv1);
		}
	}
	if ( WriteIndex(dout) < 0 ) return(-1);
	return(0);
syntax:
	printf("Syntax error in merge statement\n");
	return(-1);
}

/*
  	#] DoMerge :
  	#[ main :
*/

int main(int argc,char *argv[])
{
	int error = 0, i;
	char *s, *com, c;
	int comsize = sizeof(cfunctions)/sizeof(CFUNCTION);
	inhandle = (FILE *)stdin;
/*
	First determine where the input comes from
*/
	argc--; argv++;
	if ( argc < 0 || argc > 1 ) {
		printf("Proper call is 'minos [commandfile]'\n");
		return(-1);
	}
	if ( argc == 1 ) {
		if ( ( inhandle = fopen(*argv,"r") ) == 0 ) {
			printf("Cannot open file %s\n",*argv);
			return(-1);
		}
	}
/*
	Execute initializations if any
*/
	if ( initialize() ) return(-1);
/*
	The 'event' loop
*/
	if ( inhandle == stdin ) printf(" > ");
	while ( fgets(inbuffer,INSIZE,inhandle) ) {
		s = inbuffer;
		while ( *s ) s++;
		if ( s == inbuffer ) {
			printf("Error while reading command\n");
			break;
		}
		if ( s[-1] != '\n' ) {
			printf("Incomplete command\n");
			break;
		}
		s[-1] = '\0';
		s = inbuffer;
		while ( *s == ' ' || *s == '\t' ) s++;
		if ( *s == '%' || *s == '#' || *s == '*' || *s == '\0' ) {
			if ( inhandle == stdin ) printf(" > ");
			continue;
		}
		com = s;
		while ( isalnum(*s) ) {
			*s = tolower(*s);
			s++;
		}
		c = *s; *s = 0;
		for ( i = 0; i < comsize; i++ ) {
			if ( strcmp(com,cfunctions[i].keyword) == 0 ) break;
		}
		if ( i >= comsize ) {
			printf("--> Unknown command: %s\n",com);
			if ( inhandle == stdin ) printf(" > ");
			continue;
		}
		*s = c;
		while ( *s == ' ' || *s == '\t' ) s++;
		error = (*(cfunctions[i].func))(s);
		if ( error && inhandle != stdin ) break;
		if ( error == ENDCODE ) break;
		if ( inhandle == stdin ) printf(" > ");
	}
/*
	Cleaning if any
*/
	return(finalize());
}

/*
  	#] main :
*/
