
#ifndef __MANAGE_H__

#define __MANAGE_H__
 
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <time.h>

#ifdef UNIX
#include <unistd.h>
#include <sys/wait.h>
#endif

typedef long LONG;

#define MAXBASES 16 
#define NUMOBJECTS 100

typedef struct iniinfo {
/* should contains only LONG variables or convertiniinfo should be modified */
	LONG	entriesinindex;
	LONG	numberofindexblocks;
	LONG	firstindexblock;
	LONG	lastindexblock;
	LONG	dummy1;		/* For future extensions */
	LONG	dummy2;
	LONG	dummy3;
	LONG	dummy4;
} INIINFO;

typedef struct objects {
/* if any changes, convertblock should be adapted too!!!! */
	LONG position;
	LONG size;
	time_t date;
} OBJECTS;

typedef struct indexblock {
	LONG	flags;
	LONG	previousblock;
	LONG	position;
	OBJECTS	objects[NUMOBJECTS];
} INDEXBLOCK;

typedef struct dbase {
	INIINFO		info;
	LONG		mode;
	INDEXBLOCK	**iblocks;
	FILE		*handle;
	char		*name;
} DBASE;

typedef int (*SFUN)(char *);

typedef struct compile {
	char *keyword;
	SFUN func;
} CFUNCTION;

#ifdef UNIX
typedef struct processinfo {
	pid_t	idnumber;
	LONG	basenumber;
} PINFO;
#endif
 
#define TODISK 0
#define FROMDISK 1
#define CLEANFLAG -2L
#define DIRTYFLAG 1
#define INANDOUT 0
#define INPUTONLY 1
#define OUTPUTONLY 2

extern DBASE *dbases[];
extern int numdbases;
extern FILE *inhandle;
extern int withoutflush;
extern int numprocessors;
 
void *mmalloc(size_t size,char *message);
int mread(FILE *f,char *buffer,LONG size);
int mwrite(FILE *f,char *buffer,LONG size);
char *str_dup(char *str);
void convertblock(INDEXBLOCK *in,INDEXBLOCK *out,int mode);
void convertiniinfo(INIINFO *in,INIINFO *out,int mode);
int ReadIndex(DBASE *d);
int WriteIndexBlock(DBASE *d,LONG num);
int WriteIndex(DBASE *d);
int WriteIniInfo(DBASE *d);
int ReadIniInfo(DBASE *d);
int AddToIndex(DBASE *d,LONG number);
DBASE *GetDbase(char *filename);
DBASE *OpenDbase(char *filename);
char **ReadObject(DBASE *d,LONG number);
char *GetSubString(char *keyword,char **argv);
int WriteObject(DBASE *d,char **argv,LONG number);
LONG AddObject(DBASE *d,char **argv);
int Cleanup(DBASE *d);
DBASE *NewDbase(char *name,LONG number);
int TouchKey(DBASE *d,char *key,char *value);
int DumpContents(DBASE *d,char *filename,LONG from,LONG to);
int RunMake(int variety,char **inargv,char ***outargv,LONG num,char *outvar,int child);
int handlefold(DBASE *d,char *start,char *finish,char *name,char *varname);
int SumStart(int variety,char *outname);
int SumStep(int variety,char **argv,LONG num,char *outname);
int SpecStep(int variety,char **argv1,char **argv2,LONG num,char *outname);
int SumFinish(int variety,char *outname);
int LinSumStart(int variety,char *outname);
int LinSumStep(int variety,char **argv,LONG num,char *outname);
int LinSumDecl(int variety,char **argv,LONG num,char *outname);
int LinSumFinish(int variety,char *outname);
char *SkipString(char *);

#endif
