#-
#define CASE "g14"
*#define CASE "AnAn"
*#define CASE "FnAn"
#define n "20"
#define SIMPLE "1"
Tensor Tr(cyclic),T,Tp,f(antisymmetric),ff(rcyclic);
Function TM,TT;
Symbols a,nf,NF,NA,cF,cA,[cF-cA/6];
Dimension NA;
AutoDeclare Index j,k,n;
Dimension NF;
AutoDeclare Index i;
AutoDeclare Symbol I;
.global
#switch `CASE'
*
*	The FnFn cases refer to two parallel loops in the fundamental
*	representation. F3F3, F4F4, F5F5 are special cases. In general
*	one can use CASE -> FnFn and then n will specify the size.
*	If SIMPLE has been defined that is all that is calculated.
*	If it has not been defined, a symmetrized trace is evaluated.
*
#case F3F3
L	F3F3 = (Tr(j1,j2,j3)+Tr(j1,j3,j2))/2*Tr(j1,j2,j3)/nf^2;
#break
#case F4F4
L	F4F4 = (Tr(j1,j2,j3,j4)+Tr(j1,j2,j4,j3)+Tr(j1,j3,j2,j4)
		 +Tr(j1,j3,j4,j2)+Tr(j1,j4,j2,j3)+Tr(j1,j4,j3,j2))/6*Tr(j1,j2,j3,j4);
#break
#case F4A4
L	F4A4 = (Tr(j1,j2,j3,j4)+Tr(j1,j2,j4,j3)+Tr(j1,j3,j2,j4)
		 +Tr(j1,j3,j4,j2)+Tr(j1,j4,j2,j3)+Tr(j1,j4,j3,j2))/6
		*f(k1,k2,j1)*f(k2,k3,j2)*f(k3,k4,j3)*f(k4,k1,j4);
#break
#case A4A4
L	A4A4 = (ff(j1,j2,j3,j4)+ff(j1,j2,j4,j3)+ff(j1,j3,j2,j4)
		 +ff(j1,j3,j4,j2)+ff(j1,j4,j2,j3)+ff(j1,j4,j3,j2))/6
		*f(k1,k2,j1)*f(k2,k3,j2)*f(k3,k4,j3)*f(k4,k1,j4);
id	ff(j1?,...,j4?) = <f(n1,n2,j1)>*...*<f(n4,n5,j4)>*replace_(n5,n1);
.sort
#break
#case FnFn
L	F`n'F`n' = TT(j1,...,j`n')*Tr(j1,...,j`n');
#ifndef `SIMPLE'
id	TT(j1?,?a) = TM(j1)*TT(?a);
repeat;
	id	TT(j1?) = TM(j1);
	id	TT(?a) = distrib_(1,1,TM,TT,?a)/nargs_(?a);
endrepeat;
repeat id	TM(?a)*TM(?b) = TM(?a,?b);
id	TM(?a) = Tr(?a);
#else
id	TT(?a) = Tr(?a);
#endif
.sort
#break
#case FnAn
*
*	The FnAn cases refer to two parallel loops one in the fundamental
*	representation and one in the adjoint representation.
*	One should use CASE -> FnAn and then n will specify the size.
*	If SIMPLE has been defined that is all that is calculated.
*	If it has not been defined, a symmetrized trace is evaluated.
*
L	F`n'A`n' = TT(j1,...,j`n')*Tr(j1,...,j`n');
#ifndef `SIMPLE'
id	TT(j1?,?a) = TM(j1)*TT(?a);
repeat;
	id	TT(j1?) = TM(j1);
	id	TT(?a) = distrib_(1,1,TM,TT,?a)/nargs_(?a);
endrepeat;
repeat id	TM(?a)*TM(?b) = TM(?a,?b);
id	TM(?a) = ff(?a);
#else
id	TT(?a) = ff(?a);
#endif
id	ff(j1?,...,j`n'?) = <f(n1,n2,j1)>*...*<f(n`n',n{`n'+1},j`n')>*
				replace_(n{`n'+1},n1);
.sort
#break
#case AnAn
*
*	The AnAn cases refer to two parallel loops in the adjoint
*	representation.
*	One should use CASE -> AnAn and then n will specify the size.
*	If SIMPLE has been defined that is all that is calculated.
*	If it has not been defined, a symmetrized trace is evaluated.
*	Note that in these algorithms the adjoint representation needs
*	more time for evaluation.
*
L	A`n'A`n' = TT(j1,...,j`n')*ff(j1,...,j`n');
id	ff(j1?,...,j`n'?) = <f(k1,k2,j1)>*...*<f(k`n',k{`n'+1},j`n')>*
				replace_(k{`n'+1},k1);
#ifndef `SIMPLE'
id	TT(j1?,?a) = TM(j1)*TT(?a);
repeat;
	id	TT(j1?) = TM(j1);
	id	TT(?a) = distrib_(1,1,TM,TT,?a)/nargs_(?a);
endrepeat;
repeat id	TM(?a)*TM(?b) = TM(?a,?b);
id	TM(?a) = ff(?a);
#else
id	TT(?a) = ff(?a);
#endif
id	ff(j1?,...,j`n'?) = <f(n1,n2,j1)>*...*<f(n`n',n{`n'+1},j`n')>*
				replace_(n{`n'+1},n1);
.sort
#break
#case qloop
*
*	Here we evaluate one loop with 2*`n' vertices in the adjoint
*	representation. The vertices are connected in such a way that each
*	vertex is connected to the vertex that is the furthest away (along
*	the line in the fundamental representation).
*	One should use CASE -> qloop and then n will specify the size.
*
L	Q{2*`n'} = Tr(j1,...,j`n',j1,...,j`n');
#break
#case gloop
L	G{2*`n'} = <f(k1,k2,j1)>*...*<f(k`n',k{`n'+1},j`n')>
	*<f(k{`n'+1},k{`n'+2},j1)>*...*<f(k{`n'*2},k{2*`n'+1},j`n')>
	*replace_(k{`n'*2+1},k1);
#break
#case g14
*
*	The Coxeter graph in the adjoint representation.
*	Use CASE -> g14
*
L	g14 = f(j1,j2,j3)*f(j1,j4,j5)*f(j2,j6,j7)*f(j3,j8,j9)
		*f(j4,j10,j11)*f(j5,j12,j13)*f(j6,j14,j15)*f(j7,j16,j17)
		*f(j8,j18,j19)*f(j9,j20,j21)
		*f(j10,j21,j15)*f(j13,j19,j14)*f(j17,j11,j18)*f(j12,j16,j20);
#break
#endswitch

#call SUn
id	NA=NF^2-1;
Print +f +s;
.end
