*
*	File contains the mzv tables for weights 1 to 10 and can read in
*	the tables for higher weights from separate files.
*
*	The tables do not contain the divergent elements. These can be
*	easily derived. They also do not contain the elements that can be
*	obtained by a duality transformation. Of an element and its dual we
*	find in the tables only the one with the lowest depth (fewest ones)
*	or in the case that depth=weight/2 the one that has the smallest
*	binary interpretation (ie 001101 is kept and 010011 is not).
*	Because there can be selfdual elements the number of elements in the
*	tables is not a power of 2 for the even weights.
*	
*	Use of the tables:
*		#include- mzvtables.h
*		#call mzvtables(MaxWeight)
*	This call should be made once only at the beginning of the program and
*	MaxWeight is the maximum weight that should be looked up in the program.
*
*	J.Vermaseren 14-feb-2014
*
*--#[ mzvtables :
*
#procedure mzvtables(WW)
#do iww = 1,`WW'
#call mzv`iww'
#enddo
#endprocedure
*
*--#] mzvtables : 
*--#[ mzv1 :
*
#procedure mzv1
*
S	Sinf;
CTable,sparse,mzv1(1);
Fill mzv1(1) = Sinf;
*
#endprocedure
*
*--#] mzv1 : 
*--#[ mzv2 :
*
#procedure mzv2
*
S	z2;
CTable,sparse,mzv2(2);
Fill mzv2(0,1) = z2;
*
#endprocedure
*
*--#] mzv2 : 
*--#[ mzv3 :
*
#procedure mzv3
*
*	Note that the element (0,1,1) is the dual of (0,0,1)
*
S	z3;
CTable,sparse,mzv3(3);
Fill mzv3(0,0,1) = z3;
*
#endprocedure
*
*--#] mzv3 : 
*--#[ mzv4 :
*
#procedure mzv4
*
CTable,sparse,mzv4(4);
Fill mzv4(0,0,0,1) = 2/5*z2^2;
Fill mzv4(0,0,1,1) = 1/10*z2^2;
Fill mzv4(0,1,0,1) = 3/10*z2^2;
*
#endprocedure
*
*--#] mzv4 : 
*--#[ mzv5 :
*
#procedure mzv5
*
S	z5;
CTable,sparse,mzv5(5);
Fill mzv5(0,0,0,0,1) = z5;
Fill mzv5(0,0,0,1,1) = -z2*z3+2*z5;
Fill mzv5(0,0,1,0,1) = +3*z2*z3-11/2*z5;
Fill mzv5(0,1,0,0,1) = -2*z2*z3+9/2*z5;
*
#endprocedure
*
*--#] mzv5 : 
*--#[ mzv6 :
*
#procedure mzv6
*
CTable,sparse,mzv6(6);
Fill mzv6(0,0,0,0,0,1)=8/35*z2^3;
Fill mzv6(0,0,0,0,1,1)=6/35*z2^3-1/2*z3^2;
Fill mzv6(0,0,0,1,0,1)=-32/105*z2^3+z3^2;
Fill mzv6(0,0,0,1,1,1)=23/70*z2^3-z3^2;
Fill mzv6(0,0,1,0,0,1)=-4/35*z2^3+1/2*z3^2;
Fill mzv6(0,0,1,0,1,1)=-29/30*z2^3+3*z3^2;
Fill mzv6(0,0,1,1,0,1)=53/105*z2^3-3/2*z3^2;
Fill mzv6(0,1,0,0,0,1)=10/21*z2^3-z3^2;
Fill mzv6(0,1,0,1,0,1)=3/70*z2^3;
Fill mzv6(0,1,1,0,0,1)=-13/70*z2^3+z3^2;
*
#endprocedure
*
*--#] mzv6 : 
*--#[ mzv7 :
*
#procedure mzv7
*
S	z7;
*
CTable,sparse,mzv7(7);
Fill mzv7(0,0,0,0,0,0,1)=z7;
Fill mzv7(0,0,0,0,0,1,1)=-2/5*z2^2*z3-z2*z5+3*z7;
Fill mzv7(0,0,0,0,1,0,1)=4/5*z2^2*z3+5*z2*z5-11*z7;
Fill mzv7(0,0,0,0,1,1,1)=-1/2*z2^2*z3-2*z2*z5+5*z7;
Fill mzv7(0,0,0,1,0,0,1)=-10*z2*z5+17*z7;
Fill mzv7(0,0,0,1,0,1,1)=7/5*z2^2*z3+11/2*z2*z5-221/16*z7;
Fill mzv7(0,0,0,1,1,0,1)=-3/2*z2^2*z3+5/2*z2*z5+5/8*z7;
Fill mzv7(0,0,1,0,0,0,1)=2/5*z2^2*z3+10*z2*z5-18*z7;
Fill mzv7(0,0,1,0,0,1,1)=-9/2*z2*z5+61/8*z7;
Fill mzv7(0,0,1,0,1,0,1)=9/10*z2^2*z3-15/2*z2*z5+157/16*z7;
Fill mzv7(0,0,1,1,0,0,1)=1/10*z2^2*z3-1/4*z7;
Fill mzv7(0,1,0,0,0,0,1)=-4/5*z2^2*z3-4*z2*z5+10*z7;
Fill mzv7(0,1,0,0,0,1,1)=-1/2*z2^2*z3+5*z2*z5-109/16*z7;
Fill mzv7(0,1,0,0,1,0,1)=-11/2*z2*z5+75/8*z7;
Fill mzv7(0,1,0,1,0,0,1)=-3/5*z2^2*z3+12*z2*z5-291/16*z7;
Fill mzv7(0,1,1,0,0,0,1)=7/10*z2^2*z3-11/2*z2*z5+61/8*z7;
*
#endprocedure
*
*--#] mzv7 : 
*--#[ mzv8 :
*
#procedure mzv8
*
S	z5z3;
CTable,sparse,mzv8(8);
Fill mzv8(0,0,0,0,0,0,0,1)=24/175*z2^4;
Fill mzv8(0,0,0,0,0,0,1,1)=6/35*z2^4-z3*z5;
Fill mzv8(0,0,0,0,0,1,0,1)=-42/125*z2^4+2*z3*z5-2/5*z5z3;
Fill mzv8(0,0,0,0,0,1,1,1)=61/175*z2^4+1/2*z2*z3^2-3*z3*z5;
Fill mzv8(0,0,0,0,1,0,0,1)=z5z3;
Fill mzv8(0,0,0,0,1,0,1,1)=-2266/2625*z2^4-z2*z3^2+7*z3*z5-7/10*z5z3;
Fill mzv8(0,0,0,0,1,1,0,1)=157/2625*z2^4-3/2*z2*z3^2+5/2*z3*z5+2/5*z5z3;
Fill mzv8(0,0,0,0,1,1,1,1)=499/1400*z2^4+z2*z3^2-4*z3*z5;
Fill mzv8(0,0,0,1,0,0,0,1)=2/175*z2^4;
Fill mzv8(0,0,0,1,0,0,1,1)=29/175*z2^4+1/2*z2*z3^2-2*z3*z5+5/2*z5z3;
Fill mzv8(0,0,0,1,0,1,0,1)=2386/2625*z2^4+3*z2*z3^2-11*z3*z5-9/5*z5z3;
Fill mzv8(0,0,0,1,0,1,1,1)=-14899/21000*z2^4-2*z2*z3^2+8*z3*z5-3/5*z5z3;
Fill mzv8(0,0,0,1,1,0,0,1)=142/525*z2^4+1/2*z2*z3^2-5/2*z3*z5-z5z3;
Fill mzv8(0,0,0,1,1,0,1,1)=-1919/4200*z2^4-3/2*z2*z3^2+11/2*z3*z5+3/2*z5z3;
Fill mzv8(0,0,0,1,1,1,0,1)=7457/21000*z2^4+1/2*z2*z3^2-3*z3*z5-6/5*z5z3;
Fill mzv8(0,0,1,0,0,0,0,1)=-24/175*z2^4+z3*z5-z5z3;
Fill mzv8(0,0,1,0,0,0,1,1)=-13/21*z2^4-2*z2*z3^2+15/2*z3*z5-3/2*z5z3;
Fill mzv8(0,0,1,0,0,1,0,1)=1187/875*z2^4+9/2*z2*z3^2-33/2*z3*z5-13/10*z5z3;
Fill mzv8(0,0,1,0,1,0,0,1)=-56/25*z2^4-6*z2*z3^2+49/2*z3*z5+4*z5z3;
Fill mzv8(0,0,1,0,1,0,1,1)=19007/7000*z2^4+9*z2*z3^2-33*z3*z5-18/5*z5z3;
Fill mzv8(0,0,1,0,1,1,0,1)=-28087/21000*z2^4-3*z2*z3^2+27/2*z3*z5+27/10*z5z3;
Fill mzv8(0,0,1,1,0,0,0,1)=241/525*z2^4+3/2*z2*z3^2-11/2*z3*z5;
Fill mzv8(0,0,1,1,0,0,1,1)=1/1400*z2^4;
Fill mzv8(0,0,1,1,0,1,0,1)=-9491/7000*z2^4-9/2*z2*z3^2+33/2*z3*z5+9/5*z5z3;
Fill mzv8(0,0,1,1,1,0,0,1)=3043/4200*z2^4+2*z2*z3^2-8*z3*z5-3/2*z5z3;
Fill mzv8(0,1,0,0,0,0,0,1)=374/875*z2^4-2*z3*z5+2/5*z5z3;
Fill mzv8(0,1,0,0,0,0,1,1)=703/875*z2^4+2*z2*z3^2-17/2*z3*z5-7/10*z5z3;
Fill mzv8(0,1,0,0,0,1,0,1)=-944/525*z2^4-5*z2*z3^2+20*z3*z5+4*z5z3;
Fill mzv8(0,1,0,0,1,0,0,1)=793/875*z2^4+2*z2*z3^2-9*z3*z5-27/10*z5z3;
Fill mzv8(0,1,0,0,1,1,0,1)=56249/21000*z2^4+6*z2*z3^2-27*z3*z5-27/5*z5z3;
Fill mzv8(0,1,0,1,0,0,0,1)=803/875*z2^4+2*z2*z3^2-9*z3*z5-11/5*z5z3;
Fill mzv8(0,1,0,1,0,1,0,1)=1/280*z2^4;
Fill mzv8(0,1,0,1,1,0,0,1)=-6159/7000*z2^4-3/2*z2*z3^2+8*z3*z5+27/10*z5z3;
Fill mzv8(0,1,1,0,0,0,0,1)=-283/525*z2^4-z2*z3^2+11/2*z3*z5+z5z3;
Fill mzv8(0,1,1,0,1,0,0,1)=12713/7000*z2^4+4*z2*z3^2-18*z3*z5-27/5*z5z3;
Fill mzv8(0,1,1,1,0,0,0,1)=-3457/4200*z2^4-2*z2*z3^2+9*z3*z5+3*z5z3;
*
#endprocedure
*
*--#] mzv8 : 
*--#[ mzv9 :
*
#procedure mzv9
*
S	z9;
CTable,sparse,mzv9(9);
Fill mzv9(0,0,0,0,0,0,0,0,1)=z9;
Fill mzv9(0,0,0,0,0,0,0,1,1)=-8/35*z2^3*z3-2/5*z2^2*z5-z2*z7+4*z9;
Fill mzv9(0,0,0,0,0,0,1,0,1)=16/35*z2^3*z3+8/5*z2^2*z5+7*z2*z7-37/2*z9;
Fill mzv9(0,0,0,0,0,0,1,1,1)=-2/5*z2^3*z3-9/10*z2^2*z5-3*z2*z7+1/6*z3^3+28/3*z9
         ;
Fill mzv9(0,0,0,0,0,1,0,0,1)=-12/5*z2^2*z5-21*z2*z7+83/2*z9;
Fill mzv9(0,0,0,0,0,1,0,1,1)=36/35*z2^3*z3+13/5*z2^2*z5+11*z2*z7-1/3*z3^3-2189/
         72*z9;
Fill mzv9(0,0,0,0,0,1,1,0,1)=-8/21*z2^3*z3-1/10*z2^2*z5+7*z2*z7-1/3*z3^3-313/36
         *z9;
Fill mzv9(0,0,0,0,0,1,1,1,1)=-1/2*z2^3*z3-7/5*z2^2*z5-5*z2*z7+1/2*z3^3+14*z9;
Fill mzv9(0,0,0,0,1,0,0,0,1)=2*z2^2*z5+35*z2*z7-127/2*z9;
Fill mzv9(0,0,0,0,1,0,0,1,1)=-6/35*z2^3*z3-23/10*z2^2*z5-17*z2*z7+1/6*z3^3+845/
         24*z9;
Fill mzv9(0,0,0,0,1,0,1,0,1)=-64/105*z2^3*z3+7/10*z2^2*z5-21*z2*z7+2/3*z3^3+
         2513/72*z9;
Fill mzv9(0,0,0,0,1,0,1,1,1)=z2^3*z3+19/4*z2^2*z5+221/16*z2*z7-z3^3-1909/48*z9;
Fill mzv9(0,0,0,0,1,1,0,0,1)=2/7*z2^3*z3+1/5*z2^2*z5-7*z2*z7-1/3*z3^3+121/12*z9
         ;
Fill mzv9(0,0,0,0,1,1,0,1,1)=29/30*z2^3*z3-7/4*z2^2*z5-5/8*z2*z7-z3^3+361/144*
         z9;
Fill mzv9(0,0,0,0,1,1,1,0,1)=-19/35*z2^3*z3+3/5*z2^2*z5+189/16*z2*z7+1/2*z3^3-
         2765/144*z9;
Fill mzv9(0,0,0,1,0,0,0,0,1)=-8/5*z2^2*z5-35*z2*z7+125/2*z9;
Fill mzv9(0,0,0,1,0,0,0,1,1)=32/105*z2^3*z3+2*z2^2*z5+18*z2*z7-1/3*z3^3-328/9*
         z9;
Fill mzv9(0,0,0,1,0,0,1,0,1)=-64/105*z2^3*z3-7*z2^2*z5+14*z2*z7+2/3*z3^3-53/36*
         z9;
Fill mzv9(0,0,0,1,0,0,1,1,1)=-1/42*z2^3*z3-69/20*z2^2*z5-61/8*z2*z7+3227/144*z9
         ;
Fill mzv9(0,0,0,1,0,1,0,0,1)=8/21*z2^3*z3+4*z2^2*z5+28*z2*z7-1/3*z3^3-59*z9;
Fill mzv9(0,0,0,1,0,1,0,1,1)=-299/105*z2^3*z3-16/5*z2^2*z5-157/16*z2*z7+3*z3^3+
         845/24*z9;
Fill mzv9(0,0,0,1,0,1,1,0,1)=106/105*z2^3*z3+33/20*z2^2*z5-483/16*z2*z7-z3^3+
         1501/36*z9;
Fill mzv9(0,0,0,1,1,0,0,0,1)=-82/105*z2^3*z3-6/5*z2^2*z5+2/3*z3^3+115/18*z9;
Fill mzv9(0,0,0,1,1,0,0,1,1)=-53/105*z2^3*z3+1/4*z2^2*z5+1/4*z2*z7+1/2*z3^3+103/
         144*z9;
Fill mzv9(0,0,0,1,1,0,1,0,1)=61/70*z2^3*z3+15/4*z2^2*z5+189/16*z2*z7-z3^3-1187/
         36*z9;
Fill mzv9(0,0,0,1,1,1,0,0,1)=34/105*z2^3*z3-z2^2*z5-231/16*z2*z7-1/2*z3^3+3721/
         144*z9;
Fill mzv9(0,0,1,0,0,0,0,0,1)=8/35*z2^3*z3+12/5*z2^2*z5+21*z2*z7-85/2*z9;
Fill mzv9(0,0,1,0,0,0,0,1,1)=2/7*z2^3*z3+1/2*z2^2*z5-10*z2*z7-1/3*z3^3+341/24*
         z9;
Fill mzv9(0,0,1,0,0,0,1,0,1)=-8/15*z2^3*z3+3*z2^2*z5-14*z2*z7+2/3*z3^3+593/36*
         z9;
Fill mzv9(0,0,1,0,0,0,1,1,1)=148/105*z2^3*z3+43/10*z2^2*z5+109/16*z2*z7-3/2*
         z3^3-4067/144*z9;
Fill mzv9(0,0,1,0,0,1,0,0,1)=-4/35*z2^3*z3+1/6*z3^3+1/3*z9;
Fill mzv9(0,0,1,0,0,1,0,1,1)=-227/70*z2^3*z3-9/20*z2^2*z5-75/8*z2*z7+7/2*z3^3+
         1009/36*z9;
Fill mzv9(0,0,1,0,0,1,1,0,1)=12/35*z2^3*z3-27/20*z2^2*z5+189/16*z2*z7-1/2*z3^3-
         1205/72*z9;
Fill mzv9(0,0,1,0,1,0,0,0,1)=58/35*z2^3*z3-11/5*z2^2*z5-28*z2*z7-4/3*z3^3+46*z9
         ;
Fill mzv9(0,0,1,0,1,0,0,1,1)=309/70*z2^3*z3+291/16*z2*z7-9/2*z3^3-367/8*z9;
Fill mzv9(0,0,1,0,1,0,1,0,1)=9/70*z2^3*z3-9/4*z2^2*z5+189/16*z2*z7-223/16*z9;
Fill mzv9(0,0,1,0,1,1,0,0,1)=-28/15*z2^3*z3+441/16*z2*z7+5/2*z3^3-2879/72*z9;
Fill mzv9(0,0,1,1,0,0,0,0,1)=-4/35*z2^3*z3-1/10*z2^2*z5+7*z2*z7+1/6*z3^3-131/12
         *z9;
Fill mzv9(0,0,1,1,0,0,0,1,1)=-103/70*z2^3*z3-1/20*z2^2*z5-61/8*z2*z7+3/2*z3^3+
         865/48*z9;
Fill mzv9(0,0,1,1,0,0,1,0,1)=53/35*z2^3*z3-11/20*z2^2*z5+63/16*z2*z7-3/2*z3^3-
         251/24*z9;
Fill mzv9(0,0,1,1,0,1,0,0,1)=-2/3*z2^3*z3+9/20*z2^2*z5-441/16*z2*z7+1/2*z3^3+
         3389/72*z9;
Fill mzv9(0,0,1,1,1,0,0,0,1)=-3/35*z2^3*z3+1/2*z2^2*z5+231/16*z2*z7-397/16*z9;
Fill mzv9(0,1,0,0,0,0,0,0,1)=-16/35*z2^3*z3-8/5*z2^2*z5-6*z2*z7+35/2*z9;
Fill mzv9(0,1,0,0,0,0,0,1,1)=-86/105*z2^3*z3-7/10*z2^2*z5+7*z2*z7+2/3*z3^3-461/
         72*z9;
Fill mzv9(0,1,0,0,0,0,1,0,1)=164/105*z2^3*z3-11*z2*z7-4/3*z3^3+439/36*z9;
Fill mzv9(0,1,0,0,0,0,1,1,1)=-172/105*z2^3*z3-13/5*z2^2*z5+7*z2*z7+3/2*z3^3+265/
         144*z9;
Fill mzv9(0,1,0,0,0,1,0,0,1)=8/35*z2^3*z3-3*z2^2*z5+31*z2*z7-1/3*z3^3-1567/36*
         z9;
Fill mzv9(0,1,0,0,0,1,0,1,1)=153/35*z2^3*z3+33/20*z2^2*z5-21*z2*z7-4*z3^3+989/
         72*z9;
Fill mzv9(0,1,0,0,0,1,1,0,1)=-521/210*z2^3*z3+33/20*z2^2*z5-221/16*z2*z7+2*z3^3
         +1009/36*z9;
Fill mzv9(0,1,0,0,1,0,0,0,1)=-20/21*z2^3*z3+24/5*z2^2*z5-32*z2*z7+2/3*z3^3+1567/
         36*z9;
Fill mzv9(0,1,0,0,1,0,0,1,1)=-53/35*z2^3*z3-9/10*z2^2*z5+14*z2*z7+3/2*z3^3-91/6
         *z9;
Fill mzv9(0,1,0,0,1,0,1,0,1)=-9/4*z2^2*z5+299/8*z2*z7-889/16*z9;
Fill mzv9(0,1,0,0,1,1,0,0,1)=223/210*z2^3*z3-67/16*z2*z7-3/2*z3^3+31/8*z9;
Fill mzv9(0,1,0,1,0,0,0,0,1)=-20/21*z2^3*z3-2/5*z2^2*z5+31*z2*z7+2/3*z3^3-3319/
         72*z9;
Fill mzv9(0,1,0,1,0,0,0,1,1)=-221/210*z2^3*z3+17/10*z2^2*z5-14*z2*z7+z3^3+803/
         36*z9;
Fill mzv9(0,1,0,1,0,0,1,0,1)=3/5*z2^2*z5-291/16*z2*z7+455/16*z9;
Fill mzv9(0,1,0,1,0,1,0,0,1)=-3/35*z2^3*z3+18/5*z2^2*z5-30*z2*z7+641/16*z9;
Fill mzv9(0,1,0,1,1,0,0,0,1)=103/70*z2^3*z3-77/20*z2^2*z5-67/16*z2*z7-z3^3+839/
         72*z9;
Fill mzv9(0,1,1,0,0,0,0,0,1)=74/105*z2^3*z3+1/10*z2^2*z5-11*z2*z7-1/3*z3^3+551/
         36*z9;
Fill mzv9(0,1,1,0,0,0,0,1,1)=181/210*z2^3*z3-1/20*z2^2*z5-z3^3-391/144*z9;
Fill mzv9(0,1,1,0,0,0,1,0,1)=-19/30*z2^3*z3-33/20*z2^2*z5+173/8*z2*z7+z3^3-59/2
         *z9;
Fill mzv9(0,1,1,0,0,1,0,0,1)=-3/10*z2^3*z3+27/20*z2^2*z5-291/16*z2*z7+1/2*z3^3+
         217/8*z9;
Fill mzv9(0,1,1,0,1,0,0,0,1)=-61/105*z2^3*z3+3/20*z2^2*z5+299/8*z2*z7-2125/36*
         z9;
Fill mzv9(0,1,1,1,0,0,0,0,1)=61/210*z2^3*z3-1/5*z2^2*z5-221/16*z2*z7+3227/144*
         z9;
*
#endprocedure
*
*--#] mzv9 : 
*--#[ mzv10 :
*
#procedure mzv10
*
S	z7z3;
CTable,sparse,mzv10(10);
Fill mzv10(0,0,0,0,0,0,0,0,0,1)=32/385*z2^5;
Fill mzv10(0,0,0,0,0,0,0,0,1,1)=8/55*z2^5-z3*z7-1/2*z5^2;
Fill mzv10(0,0,0,0,0,0,0,1,0,1)=-816/2695*z2^5+2*z3*z7+8/7*z5^2-2/7*z7z3;
Fill mzv10(0,0,0,0,0,0,0,1,1,1)=666/1925*z2^5+1/5*z2^2*z3^2+z2*z3*z5-4*z3*z7-2*
         z5^2;
Fill mzv10(0,0,0,0,0,0,1,0,0,1)=z7z3;
Fill mzv10(0,0,0,0,0,0,1,0,1,1)=-175346/202125*z2^5-2/5*z2^2*z3^2-2*z2*z3*z5+2/5
         *z2*z5z3+9*z3*z7+135/28*z5^2-9/14*z7z3;
Fill mzv10(0,0,0,0,0,0,1,1,0,1)=-33664/202125*z2^5-2/5*z2^2*z3^2-5*z2*z3*z5-2/5*
         z2*z5z3+8*z3*z7+27/7*z5^2+2/7*z7z3;
Fill mzv10(0,0,0,0,0,0,1,1,1,1)=139/275*z2^5+9/20*z2^2*z3^2+3*z2*z3*z5-8*z3*z7-4
         *z5^2;
Fill mzv10(0,0,0,0,0,1,0,0,0,1)=16/175*z2^5-z5^2-z7z3;
Fill mzv10(0,0,0,0,0,1,0,0,1,1)=24/175*z2^5+1/5*z2^2*z3^2+z2*z3*z5-z2*z5z3-3*z3*
         z7-3/4*z5^2+5/2*z7z3;
Fill mzv10(0,0,0,0,0,1,0,1,0,1)=104812/67375*z2^5+4/5*z2^2*z3^2+10*z2*z3*z5-2/5*
         z2*z5z3-22*z3*z7-102/7*z5^2-6/7*z7z3;
Fill mzv10(0,0,0,0,0,1,0,1,1,1)=-165057/134750*z2^5-9/10*z2^2*z3^2-6*z2*z3*z5+7/
         10*z2*z5z3+16*z3*z7+2321/224*z5^2-141/224*z7z3;
Fill mzv10(0,0,0,0,0,1,1,0,0,1)=334/875*z2^5-1/5*z2^2*z3^2+9*z2*z3*z5+7/5*z2*
         z5z3-14*z3*z7-5*z5^2-z7z3;
Fill mzv10(0,0,0,0,0,1,1,0,1,1)=-26359/57750*z2^5-7/10*z2^2*z3^2-11/2*z2*z3*z5-2/
         5*z2*z5z3+221/16*z3*z7+83/32*z5^2+17/32*z7z3;
Fill mzv10(0,0,0,0,0,1,1,1,0,1)=-49811/404250*z2^5+3/4*z2^2*z3^2-11/2*z2*z3*z5-3/
         10*z2*z5z3+35/8*z3*z7+947/224*z5^2-39/224*z7z3;
Fill mzv10(0,0,0,0,0,1,1,1,1,1)=1341/2200*z2^5+1/2*z2^2*z3^2+4*z2*z3*z5-10*z3*z7
         -5*z5^2;
Fill mzv10(0,0,0,0,1,0,0,0,0,1)=-16/385*z2^5+1/2*z5^2;
Fill mzv10(0,0,0,0,1,0,0,0,1,1)=58/5775*z2^5-2/5*z2^2*z3^2-5*z2*z3*z5+11*z3*z7-3/
         2*z5^2-3*z7z3;
Fill mzv10(0,0,0,0,1,0,0,1,0,1)=-2566/13475*z2^5+4/5*z2^2*z3^2+10*z2*z3*z5+5*z2*
         z5z3-22*z3*z7+131/28*z5^2-19/14*z7z3;
Fill mzv10(0,0,0,0,1,0,0,1,1,1)=97/825*z2^5-3/20*z2^2*z3^2-3*z2*z3*z5-5/2*z2*
         z5z3+6*z3*z7-27/16*z5^2+35/16*z7z3;
Fill mzv10(0,0,0,0,1,0,1,0,0,1)=-1016/385*z2^5-4/5*z2^2*z3^2-30*z2*z3*z5-4*z2*
         z5z3+56*z3*z7+107/4*z5^2+7/2*z7z3;
Fill mzv10(0,0,0,0,1,0,1,0,1,1)=422397/134750*z2^5+13/5*z2^2*z3^2+26*z2*z3*z5+9/
         5*z2*z5z3-485/8*z3*z7-5799/224*z5^2-477/224*z7z3;
Fill mzv10(0,0,0,0,1,0,1,1,0,1)=-97148/202125*z2^5-3/2*z2^2*z3^2+5*z2*z3*z5-3/10
         *z2*z5z3+5/4*z3*z7-11/112*z5^2+141/112*z7z3;
Fill mzv10(0,0,0,0,1,0,1,1,1,1)=-2605957/1617000*z2^5-z2^2*z3^2-8*z2*z3*z5+3/5*
         z2*z5z3+20*z3*z7+1609/112*z5^2-61/112*z7z3;
Fill mzv10(0,0,0,0,1,1,0,0,0,1)=22/525*z2^5+1/5*z2^2*z3^2-5*z2*z3*z5-z2*z5z3+7*
         z3*z7+1/2*z5^2+z7z3;
Fill mzv10(0,0,0,0,1,1,0,0,1,1)=-61/1925*z2^5+9/2*z2*z3*z5+z2*z5z3-61/8*z3*z7+5/
         16*z5^2-1/16*z7z3;
Fill mzv10(0,0,0,0,1,1,0,1,0,1)=-192853/202125*z2^5-33/20*z2^2*z3^2-15/2*z2*z3*
         z5-9/5*z2*z5z3+371/16*z3*z7+277/56*z5^2+6/7*z7z3;
Fill mzv10(0,0,0,0,1,1,0,1,1,1)=15661/46200*z2^5-9/20*z2^2*z3^2-7/2*z2*z3*z5-3/2
         *z2*z5z3+141/16*z3*z7-171/32*z5^2+39/32*z7z3;
Fill mzv10(0,0,0,0,1,1,1,0,0,1)=26974/28875*z2^5+1/10*z2^2*z3^2+13*z2*z3*z5+9/5*
         z2*z5z3-91/4*z3*z7-161/16*z5^2-23/16*z7z3;
Fill mzv10(0,0,0,0,1,1,1,0,1,1)=-317767/231000*z2^5-19/20*z2^2*z3^2-3*z2*z3*z5+6/
         5*z2*z5z3+179/16*z3*z7+381/32*z5^2-17/32*z7z3;
Fill mzv10(0,0,0,0,1,1,1,1,0,1)=49829/67375*z2^5+3/2*z2^2*z3^2-7/2*z2*z3*z5-3/10
         *z2*z5z3-61/16*z3*z7-615/224*z5^2-93/224*z7z3;
Fill mzv10(0,0,0,1,0,0,0,0,0,1)=-32/385*z2^5+z5^2+z7z3;
Fill mzv10(0,0,0,1,0,0,0,0,1,1)=-24/275*z2^5+10*z2*z3*z5+z2*z5z3-17*z3*z7+z5^2+2
         *z7z3;
Fill mzv10(0,0,0,1,0,0,0,1,0,1)=-7704/13475*z2^5-20*z2*z3*z5-4*z2*z5z3+34*z3*z7+
         45/7*z5^2+15/7*z7z3;
Fill mzv10(0,0,0,1,0,0,0,1,1,1)=251/5775*z2^5-7/10*z2^2*z3^2+9/2*z2*z3*z5+3/2*z2
         *z5z3-51/16*z3*z7-3*z5^2-2*z7z3;
Fill mzv10(0,0,0,1,0,0,1,0,0,1)=632/275*z2^5-4*z2*z5z3-51/2*z5^2-z7z3;
Fill mzv10(0,0,0,1,0,0,1,0,1,1)=-402667/202125*z2^5+7/5*z2^2*z3^2-19*z2*z3*z5+13/
         10*z2*z5z3+187/8*z3*z7+1513/56*z5^2+75/56*z7z3;
Fill mzv10(0,0,0,1,0,0,1,1,0,1)=898829/404250*z2^5+3/4*z2^2*z3^2+55/2*z2*z3*z5+
         21/5*z2*z5z3-413/8*z3*z7-4947/224*z5^2-893/224*z7z3;
Fill mzv10(0,0,0,1,0,1,0,0,0,1)=8128/5775*z2^5+2/5*z2^2*z3^2+40*z2*z3*z5+8*z2*
         z5z3-70*z3*z7-15*z5^2-5*z7z3;
Fill mzv10(0,0,0,1,0,1,0,0,1,1)=-1564/1155*z2^5-21/10*z2^2*z3^2-51/2*z2*z3*z5-4*
         z2*z5z3+907/16*z3*z7+31/4*z5^2+3/4*z7z3;
Fill mzv10(0,0,0,1,0,1,0,1,0,1)=-35941/67375*z2^5+9/10*z2^2*z3^2-15*z2*z3*z5-9/5
         *z2*z5z3+157/8*z3*z7+1039/112*z5^2+141/112*z7z3;
Fill mzv10(0,0,0,1,0,1,0,1,1,1)=3117803/1617000*z2^5+14/5*z2^2*z3^2+22*z2*z3*z5+
         18/5*z2*z5z3-221/4*z3*z7-1303/112*z5^2-285/112*z7z3;
Fill mzv10(0,0,0,1,0,1,1,0,0,1)=-657319/404250*z2^5+4/5*z2^2*z3^2-49/2*z2*z3*z5-
         27/10*z2*z5z3+587/16*z3*z7+4659/224*z5^2+629/224*z7z3;
Fill mzv10(0,0,0,1,0,1,1,0,1,1)=3535619/1617000*z2^5+21/10*z2^2*z3^2+15/2*z2*z3*
         z5-27/10*z2*z5z3-419/16*z3*z7-1877/112*z5^2+107/112*z7z3;
Fill mzv10(0,0,0,1,0,1,1,1,0,1)=-261823/202125*z2^5-17/5*z2^2*z3^2+4*z2*z3*z5-3/
         10*z2*z5z3+61/4*z3*z7+461/224*z5^2+359/224*z7z3;
Fill mzv10(0,0,0,1,1,0,0,0,0,1)=86/5775*z2^5+2/5*z2^2*z3^2-6*z2*z3*z5-z2*z5z3+7*
         z3*z7+2*z5^2;
Fill mzv10(0,0,0,1,1,0,0,0,1,1)=436/1155*z2^5+17/10*z2^2*z3^2-2*z2*z3*z5-61/8*z3
         *z7+2*z5^2;
Fill mzv10(0,0,0,1,1,0,0,1,0,1)=16201/26950*z2^5-9/4*z2^2*z3^2+13*z2*z3*z5-15/2*
         z3*z7-3333/224*z5^2-187/224*z7z3;
Fill mzv10(0,0,0,1,1,0,0,1,1,1)=3569/46200*z2^5+3/2*z2^2*z3^2-5*z2*z3*z5-5/4*z3*
         z7+37/8*z5^2-1/8*z7z3;
Fill mzv10(0,0,0,1,1,0,1,0,0,1)=4439/80850*z2^5+9/5*z2^2*z3^2+13*z2*z3*z5+9/2*z2
         *z5z3-545/16*z3*z7+1389/224*z5^2-293/224*z7z3;
Fill mzv10(0,0,0,1,1,0,1,0,1,1)=-231467/231000*z2^5-24/5*z2^2*z3^2-3/2*z2*z3*z5-
         9/5*z2*z5z3+67/2*z3*z7-49/8*z5^2+1/4*z7z3;
Fill mzv10(0,0,0,1,1,0,1,1,0,1)=-128017/134750*z2^5+9/4*z2^2*z3^2-2*z2*z3*z5+21/
         5*z2*z5z3-45/4*z3*z7+2097/112*z5^2-141/112*z7z3;
Fill mzv10(0,0,0,1,1,1,0,0,0,1)=-3503/5775*z2^5-13/10*z2^2*z3^2-12*z2*z3*z5-3*z2
         *z5z3+28*z3*z7+3*z5^2+2*z7z3;
Fill mzv10(0,0,0,1,1,1,0,0,1,1)=3859/9240*z2^5+13/20*z2^2*z3^2+10*z2*z3*z5+3/2*
         z2*z5z3-339/16*z3*z7-37/16*z5^2+1/16*z7z3;
Fill mzv10(0,0,0,1,1,1,0,1,0,1)=616463/808500*z2^5+27/20*z2^2*z3^2-19/2*z2*z3*z5
         -33/10*z2*z5z3+57/8*z3*z7-713/224*z5^2+229/224*z7z3;
Fill mzv10(0,0,0,1,1,1,1,0,0,1)=25631/115500*z2^5-7/5*z2^2*z3^2+6*z2*z3*z5+3/10*
         z2*z5z3-7/4*z3*z7-55/8*z5^2-5/8*z7z3;
Fill mzv10(0,0,1,0,0,0,0,0,0,1)=-32/385*z2^5+z3*z7-z7z3;
Fill mzv10(0,0,1,0,0,0,0,0,1,1)=-7274/9625*z2^5-2/5*z2^2*z3^2-11*z2*z3*z5-2/5*z2
         *z5z3+21*z3*z7+29/4*z5^2-1/2*z7z3;
Fill mzv10(0,0,1,0,0,0,0,1,0,1)=42766/13475*z2^5+4/5*z2^2*z3^2+25*z2*z3*z5-z2*
         z5z3-47*z3*z7-463/14*z5^2-13/7*z7z3;
Fill mzv10(0,0,1,0,0,0,0,1,1,1)=-13648/9625*z2^5-9/20*z2^2*z3^2-15/2*z2*z3*z5+7/
         10*z2*z5z3+123/8*z3*z7+231/16*z5^2+21/16*z7z3;
Fill mzv10(0,0,1,0,0,0,1,0,0,1)=-8688/1925*z2^5-10*z2*z3*z5+8*z2*z5z3+17*z3*z7+
         50*z5^2;
Fill mzv10(0,0,1,0,0,0,1,0,1,1)=365413/80850*z2^5+13/10*z2^2*z3^2+53/2*z2*z3*z5-
         4*z2*z5z3-841/16*z3*z7-10391/224*z5^2-281/224*z7z3;
Fill mzv10(0,0,1,0,0,0,1,1,0,1)=-290537/134750*z2^5-9/5*z2^2*z3^2-20*z2*z3*z5-33/
         10*z2*z5z3+717/16*z3*z7+4139/224*z5^2+829/224*z7z3;
Fill mzv10(0,0,1,0,0,1,0,0,0,1)=4336/1925*z2^5+1/5*z2^2*z3^2+10*z2*z3*z5-4*z2*
         z5z3-18*z3*z7-49/2*z5^2+z7z3;
Fill mzv10(0,0,1,0,0,1,0,0,1,1)=-1169/1375*z2^5+27/10*z2*z5z3+75/8*z5^2-z7z3;
Fill mzv10(0,0,1,0,0,1,0,1,0,1)=-31337/12250*z2^5+27/20*z2^2*z3^2-45/2*z2*z3*z5+
         27/10*z2*z5z3+471/16*z3*z7+7461/224*z5^2+23/224*z7z3;
Fill mzv10(0,0,1,0,0,1,1,0,0,1)=8823/9625*z2^5-9/2*z2*z3*z5-27/10*z2*z5z3+61/8*
         z3*z7-81/8*z5^2;
Fill mzv10(0,0,1,0,0,1,1,0,1,1)=-137393/77000*z2^5+27/5*z2*z5z3+315/16*z5^2-27/
         16*z7z3;
Fill mzv10(0,0,1,0,0,1,1,1,0,1)=313543/134750*z2^5-9/20*z2^2*z3^2+33/2*z2*z3*z5-
         9/5*z2*z5z3-401/16*z3*z7-3083/112*z5^2-85/112*z7z3;
Fill mzv10(0,0,1,0,1,0,0,0,0,1)=-200/77*z2^5-8/5*z2^2*z3^2-32*z2*z3*z5-4*z2*z5z3
         +66*z3*z7+87/4*z5^2+9/2*z7z3;
Fill mzv10(0,0,1,0,1,0,0,0,1,1)=39866/28875*z2^5-6/5*z2^2*z3^2+63/2*z2*z3*z5+11/
         5*z2*z5z3-91/2*z3*z7-20*z5^2-1/4*z7z3;
Fill mzv10(0,0,1,0,1,0,0,1,0,1)=-5151/2695*z2^5-33/2*z2*z3*z5+225/8*z3*z7+2369/
         112*z5^2+225/112*z7z3;
Fill mzv10(0,0,1,0,1,0,1,0,0,1)=9424/1925*z2^5-9/5*z2^2*z3^2+51*z2*z3*z5-1187/16
         *z3*z7-495/8*z5^2-4*z7z3;
Fill mzv10(0,0,1,0,1,0,1,0,1,1)=-377283/107800*z2^5+27/10*z2^2*z3^2-45*z2*z3*z5+
         471/8*z3*z7+2733/56*z5^2+141/56*z7z3;
Fill mzv10(0,0,1,0,1,0,1,1,0,1)=-24111/67375*z2^5-33/2*z2*z3*z5-9/5*z2*z5z3+225/
         8*z3*z7+867/224*z5^2+9/224*z7z3;
Fill mzv10(0,0,1,0,1,1,0,0,0,1)=-5993/80850*z2^5+21/10*z2^2*z3^2+6*z2*z3*z5+9/2*
         z2*z5z3-341/16*z3*z7+1243/224*z5^2-715/224*z7z3;
Fill mzv10(0,0,1,0,1,1,0,0,1,1)=350269/1617000*z2^5+3/20*z2^2*z3^2-27/2*z2*z3*z5
         -27/10*z2*z5z3+177/8*z3*z7-225/112*z5^2-75/112*z7z3;
Fill mzv10(0,0,1,0,1,1,0,1,0,1)=539051/269500*z2^5-9/10*z2^2*z3^2+36*z2*z3*z5+27/
         10*z2*z5z3-873/16*z3*z7-1479/56*z5^2-27/14*z7z3;
Fill mzv10(0,0,1,0,1,1,1,0,0,1)=-606721/269500*z2^5+23/10*z2^2*z3^2-37/2*z2*z3*
         z5+9/5*z2*z5z3+147/8*z3*z7+1753/56*z5^2+71/56*z7z3;
Fill mzv10(0,0,1,1,0,0,0,0,0,1)=5574/9625*z2^5+1/5*z2^2*z3^2+10*z2*z3*z5+7/5*z2*
         z5z3-18*z3*z7-6*z5^2-z7z3;
Fill mzv10(0,0,1,1,0,0,0,0,1,1)=4/175*z2^5-1/20*z2^2*z3^2-9/2*z2*z3*z5-z2*z5z3+
         63/8*z3*z7-5/16*z5^2+1/16*z7z3;
Fill mzv10(0,0,1,1,0,0,0,1,0,1)=-448109/404250*z2^5+11/20*z2^2*z3^2-15/2*z2*z3*
         z5+9/5*z2*z5z3+149/16*z3*z7+3163/224*z5^2-75/224*z7z3;
Fill mzv10(0,0,1,1,0,0,1,0,0,1)=8273/9625*z2^5+1/20*z2^2*z3^2-27/10*z2*z5z3-1/4*
         z3*z7-75/8*z5^2+z7z3;
Fill mzv10(0,0,1,1,0,0,1,1,0,1)=-9431/80850*z2^5-3/20*z2^2*z3^2+3/4*z3*z7+225/
         224*z5^2+75/224*z7z3;
Fill mzv10(0,0,1,1,0,1,0,0,0,1)=-947249/404250*z2^5-7/10*z2^2*z3^2-30*z2*z3*z5-
         27/10*z2*z5z3+109/2*z3*z7+5533/224*z5^2+715/224*z7z3;
Fill mzv10(0,0,1,1,0,1,0,0,1,1)=-107661/539000*z2^5+27*z2*z3*z5+27/5*z2*z5z3-183/
         4*z3*z7+225/112*z5^2+75/112*z7z3;
Fill mzv10(0,0,1,1,0,1,0,1,0,1)=47163/26950*z2^5-27/20*z2^2*z3^2+45/2*z2*z3*z5-
         471/16*z3*z7-2733/112*z5^2-141/112*z7z3;
Fill mzv10(0,0,1,1,0,1,1,0,0,1)=17411/9625*z2^5-9/2*z2*z3*z5-27/5*z2*z5z3+61/8*
         z3*z7-639/32*z5^2+27/32*z7z3;
Fill mzv10(0,0,1,1,1,0,0,0,0,1)=2909/2625*z2^5+13/20*z2^2*z3^2+14*z2*z3*z5+9/5*
         z2*z5z3-113/4*z3*z7-155/16*z5^2-33/16*z7z3;
Fill mzv10(0,0,1,1,1,0,0,0,1,1)=-8101/46200*z2^5+1/2*z2^2*z3^2-19*z2*z3*z5-3*z2*
         z5z3+231/8*z3*z7+4*z5^2;
Fill mzv10(0,0,1,1,1,0,0,1,0,1)=83543/202125*z2^5-3/10*z2^2*z3^2+13*z2*z3*z5+9/5
         *z2*z5z3-20*z3*z7-1317/224*z5^2-131/224*z7z3;
Fill mzv10(0,0,1,1,1,0,1,0,0,1)=-539822/202125*z2^5+7/10*z2^2*z3^2-22*z2*z3*z5+9/
         5*z2*z5z3+517/16*z3*z7+7345/224*z5^2+143/224*z7z3;
Fill mzv10(0,0,1,1,1,1,0,0,0,1)=3383/5250*z2^5-11/20*z2^2*z3^2+21/2*z2*z3*z5+3/
         10*z2*z5z3-235/16*z3*z7-139/16*z5^2-1/16*z7z3;
Fill mzv10(0,1,0,0,0,0,0,0,0,1)=4808/13475*z2^5-2*z3*z7-8/7*z5^2+2/7*z7z3;
Fill mzv10(0,1,0,0,0,0,0,0,1,1)=14284/13475*z2^5+4/5*z2^2*z3^2+6*z2*z3*z5-16*z3*
         z7-229/28*z5^2-9/14*z7z3;
Fill mzv10(0,1,0,0,0,0,0,1,0,1)=-31146/9625*z2^5-8/5*z2^2*z3^2-18*z2*z3*z5+2/5*
         z2*z5z3+42*z3*z7+29*z5^2+3*z7z3;
Fill mzv10(0,1,0,0,0,0,0,1,1,1)=173599/134750*z2^5+23/20*z2^2*z3^2+3*z2*z3*z5-2/
         5*z2*z5z3-211/16*z3*z7-2113/224*z5^2-275/224*z7z3;
Fill mzv10(0,1,0,0,0,0,1,0,0,1)=38686/13475*z2^5+20*z2*z3*z5-34*z3*z7-447/14*
         z5^2-22/7*z7z3;
Fill mzv10(0,1,0,0,0,0,1,0,1,1)=-212603/67375*z2^5-31/10*z2^2*z3^2-13*z2*z3*z5-2/
         5*z2*z5z3+44*z3*z7+1221/56*z5^2+22/7*z7z3;
Fill mzv10(0,1,0,0,0,0,1,1,0,1)=186209/67375*z2^5+27/10*z2^2*z3^2+25/2*z2*z3*z5+
         7/10*z2*z5z3-325/8*z3*z7-2109/112*z5^2-325/112*z7z3;
Fill mzv10(0,1,0,0,0,1,0,0,0,1)=-33658/40425*z2^5-2/5*z2^2*z3^2-20*z2*z3*z5-4*z2
         *z5z3+36*z3*z7+60/7*z5^2+20/7*z7z3;
Fill mzv10(0,1,0,0,0,1,0,0,1,1)=-85661/80850*z2^5+1/4*z2^2*z3^2+4*z2*z3*z5+5*z2*
         z5z3-135/16*z3*z7+2815/224*z5^2-359/224*z7z3;
Fill mzv10(0,1,0,0,0,1,0,1,0,1)=227/1925*z2^5-9/10*z2^2*z3^2+4*z2*z3*z5-7/8*z3*
         z7-75/16*z5^2-1/16*z7z3;
Fill mzv10(0,1,0,0,0,1,1,0,0,1)=-195973/134750*z2^5-1/20*z2^2*z3^2-7*z2*z3*z5+4/
         5*z2*z5z3+95/8*z3*z7+3669/224*z5^2+299/224*z7z3;
Fill mzv10(0,1,0,0,0,1,1,1,0,1)=-549389/539000*z2^5+z2^2*z3^2-9*z2*z3*z5+3/5*z2*
         z5z3+17/2*z3*z7+429/28*z5^2+17/28*z7z3;
Fill mzv10(0,1,0,0,1,0,0,0,0,1)=-7934/13475*z2^5+4/5*z2^2*z3^2+8*z2*z3*z5+4*z2*
         z5z3-20*z3*z7+303/28*z5^2-23/14*z7z3;
Fill mzv10(0,1,0,0,1,0,0,0,1,1)=2414/2695*z2^5+1/2*z2^2*z3^2-9/2*z2*z3*z5-4*z2*
         z5z3+17/4*z3*z7-439/56*z5^2+73/56*z7z3;
Fill mzv10(0,1,0,0,1,0,0,1,0,1)=4329/1375*z2^5-67/10*z2*z5z3-279/8*z5^2;
Fill mzv10(0,1,0,0,1,0,1,0,0,1)=-4989/13475*z2^5+11*z2*z3*z5+4*z2*z5z3-75/4*z3*
         z7+459/112*z5^2-225/112*z7z3;
Fill mzv10(0,1,0,0,1,0,1,1,0,1)=1/15400*z2^5;
Fill mzv10(0,1,0,0,1,1,0,0,0,1)=89857/80850*z2^5-21/20*z2^2*z3^2+11*z2*z3*z5-27/
         2*z3*z7-3219/224*z5^2-149/224*z7z3;
Fill mzv10(0,1,0,0,1,1,0,1,0,1)=-885109/539000*z2^5+9/10*z2^2*z3^2-39/2*z2*z3*z5
         -9/10*z2*z5z3+423/16*z3*z7+5049/224*z5^2+423/224*z7z3;
Fill mzv10(0,1,0,0,1,1,1,0,0,1)=-212517/539000*z2^5-3/2*z2^2*z3^2+3/2*z2*z3*z5+3/
         10*z2*z5z3+85/16*z3*z7+225/224*z5^2+75/224*z7z3;
Fill mzv10(0,1,0,1,0,0,0,0,0,1)=22838/13475*z2^5+4/5*z2^2*z3^2+8*z2*z3*z5-20*z3*
         z7-101/7*z5^2-15/7*z7z3;
Fill mzv10(0,1,0,1,0,0,0,0,1,1)=-35689/26950*z2^5+4/5*z2^2*z3^2-22*z2*z3*z5-z2*
         z5z3+509/16*z3*z7+4047/224*z5^2+173/224*z7z3;
Fill mzv10(0,1,0,1,0,0,0,1,0,1)=12543/9625*z2^5-3/5*z2^2*z3^2+35*z2*z3*z5+29/5*
         z2*z5z3-441/8*z3*z7-277/16*z5^2-63/16*z7z3;
Fill mzv10(0,1,0,1,0,0,1,0,0,1)=-86943/26950*z2^5+3/5*z2^2*z3^2-24*z2*z3*z5+291/
         8*z3*z7+8667/224*z5^2+873/224*z7z3;
Fill mzv10(0,1,0,1,0,1,0,0,0,1)=-11926/13475*z2^5+3/5*z2^2*z3^2-24*z2*z3*z5-4*z2
         *z5z3+291/8*z3*z7+1425/112*z5^2+307/112*z7z3;
Fill mzv10(0,1,0,1,0,1,0,1,0,1)=3/15400*z2^5;
Fill mzv10(0,1,0,1,0,1,1,0,0,1)=1259997/539000*z2^5-9/20*z2^2*z3^2+57/2*z2*z3*z5
         +27/10*z2*z5z3-179/4*z3*z7-6399/224*z5^2-873/224*z7z3;
Fill mzv10(0,1,0,1,1,0,0,0,0,1)=-109603/202125*z2^5-3/2*z2^2*z3^2-4/5*z2*z5z3+
         189/16*z3*z7-95/56*z5^2+23/14*z7z3;
Fill mzv10(0,1,0,1,1,0,0,1,0,1)=-412059/107800*z2^5-33*z2*z3*z5+225/4*z3*z7+2369/
         56*z5^2+225/56*z7z3;
Fill mzv10(0,1,0,1,1,0,1,0,0,1)=1497513/539000*z2^5+11*z2*z3*z5-27/10*z2*z5z3-75/
         4*z3*z7-3447/112*z5^2-225/112*z7z3;
Fill mzv10(0,1,0,1,1,1,0,0,0,1)=-205949/1617000*z2^5+2/5*z2^2*z3^2-9/2*z2*z3*z5-
         3/10*z2*z5z3+103/16*z3*z7+75/56*z5^2-3/56*z7z3;
Fill mzv10(0,1,1,0,0,0,0,0,0,1)=-2866/4125*z2^5-2/5*z2^2*z3^2-4*z2*z3*z5-2/5*z2*
         z5z3+11*z3*z7+5*z5^2+z7z3;
Fill mzv10(0,1,1,0,0,0,0,0,1,1)=24463/57750*z2^5-4/5*z2^2*z3^2+19/2*z2*z3*z5+4/5
         *z2*z5z3-183/16*z3*z7-227/32*z5^2-17/32*z7z3;
Fill mzv10(0,1,1,0,0,0,0,1,0,1)=-1677/1225*z2^5+11/10*z2^2*z3^2-23/2*z2*z3*z5+
         109/8*z3*z7+2005/112*z5^2+197/112*z7z3;
Fill mzv10(0,1,1,0,0,0,1,0,0,1)=67709/19250*z2^5-3/10*z2^2*z3^2+2*z2*z3*z5-29/5*
         z2*z5z3-19/16*z3*z7-1293/32*z5^2-59/32*z7z3;
Fill mzv10(0,1,1,0,0,1,0,0,0,1)=-5371/1750*z2^5+11/20*z2^2*z3^2+9/2*z2*z3*z5+67/
         10*z2*z5z3-83/8*z3*z7+1125/32*z5^2+27/32*z7z3;
Fill mzv10(0,1,1,0,0,1,1,0,0,1)=291/15400*z2^5+1/10*z2^2*z3^2-1/2*z3*z7;
Fill mzv10(0,1,1,0,1,0,0,0,0,1)=11698/3675*z2^5+1/10*z2^2*z3^2+19*z2*z3*z5-141/4
         *z3*z7-3621/112*z5^2-493/112*z7z3;
Fill mzv10(0,1,1,0,1,0,1,0,0,1)=-695523/107800*z2^5+6/5*z2^2*z3^2-48*z2*z3*z5+
         291/4*z3*z7+8667/112*z5^2+873/112*z7z3;
Fill mzv10(0,1,1,0,1,1,0,0,0,1)=2577/7000*z2^5+1/20*z2^2*z3^2+13/2*z2*z3*z5+9/10
         *z2*z5z3-169/16*z3*z7-153/32*z5^2-27/32*z7z3;
Fill mzv10(0,1,1,1,0,0,0,0,0,1)=-9131/8250*z2^5-1/20*z2^2*z3^2-19/2*z2*z3*z5-7/
         10*z2*z5z3+141/8*z3*z7+363/32*z5^2+65/32*z7z3;
Fill mzv10(0,1,1,1,0,1,0,0,0,1)=925559/323400*z2^5-7/5*z2^2*z3^2+22*z2*z3*z5-61/
         2*z3*z7-3849/112*z5^2-359/112*z7z3;
Fill mzv10(0,1,1,1,1,0,0,0,0,1)=-85073/77000*z2^5+7/10*z2^2*z3^2-11*z2*z3*z5-3/5
         *z2*z5z3+61/4*z3*z7+113/8*z5^2+11/8*z7z3;
*
#endprocedure
*
*--#] mzv10 : 

