*--#[ Startup :
*
CF	fun0,fun1,...,fun20,funa0,funa1,funa2;
Set funs:fun0,fun1,...,fun20,funa0,funa1,funa2;
AutoDeclare Symbols i,j,l,m,n,x,y,h,e,s,z;
AutoDeclare CF S,H,Z,K,sum,den,sign;
CF	R,RR,R1,R2,R3,R4,fff(s),ffs;
CF  E,EE,Eb,EN,binom,acc1,Markett,A,B;
S	n,k,a,b,c,aa,ab,ac,sa,sb,sc;
S	Sinf,ln2,z2;
Table,sparse,Hfill(1);
#include mzvtables.h
#call mzvtables({`WEIGHT'-1})
*
#ifdef `MODULUS'
Modulus,plusmin,nodollars,`MODULUS';
#endif
*
On Parallel;
On HighFirst;
On FewerStatistics;
Format nospaces;
*#define SINF "Sinf"
#define SINF "0"
*
*--#] Startup : 
*--#[ clean :
*
#procedure clean(type)
*
*   The handling of the equations once they have been properly constructed
*   First convert back to 'table notation' of equation 8 in the paper
*
  id  HH(?a) = H(?a);
  #call makeHfinite
  .sort: after makeHfinite(`DEPTH'-`type');
  InParallel;
  if ( count(H,1,ln2,1,Sinf,1) > 1 );
	  #call duality(H)
	  #do k = 1,`WEIGHT'-1
    	id  H(n1?,...,n`k'?) = mzv`k'(n1,...,n`k');
	  #enddo
  else;
#if ( {2*`DEPTH'} == `WEIGHT' )
	  #call duality(H)
#endif
	  #call frombasis(`WEIGHT')
  endif;
  .sort: finite(`DEPTH'-`type');
  InParallel;
*
*   Now some trick to be able to substitute the H-functions of the proper
*   weight by the contents of the appropriate bracket in FF.
*
  #call convert(H,`WEIGHT',0)
  id  H(?a) = R(E(?a));
  id  R(n?$n) = FF[$n];
*
*   Bracket in H so that we may take the first bracket
*
  B   H;
ModuleOption,local,$n;
 .sort: setup(`DEPTH'-`type')-`$count';
ClearTable Hfill;
Off Statistics;
Off Parallel;
*
*	Now we have `$jj' equations
*
  #$v = 0;
  #do k1 = 1,`$jj'
  #if ( termsin(F`k1') != 0 )
	InParallel;
    Skip F`k1';
	#$v = $v + 1;
    #$vna`$v' = `k1';
    #$fb`$v' = FirstBracket_(F`k1');
    #$fv = F`k1'[$fb`$v'];
	#$fv = 1/(`$fv');
    #$fr`$v' = -F`k1'*(`$fv')+`$fb`$v'';
    id `$fb`$v'' = `$fr`$v'';
	B	H;
	.sort:Preparing `$dcount';
    #$dcount = $dcount-1;
  #endif
  #enddo
  #if ( `$v' > 0 )
	InParallel;
	id	H(?a) = Hfill(?a);
	B	Hfill;
	.sort:Setting Hfill `$dcount';
    #do k1 = 1,`$v'
      #$fb`k1' = FirstBracket_(F`$vna`k1'');
      #$fv = F`$vna`k1''[$fb`k1'];
	  #$fv = 1/(`$fv');
      #$fr`k1' = (-F`$vna`k1''*(`$fv')+`$fb`k1'')*replace_(Hfill,H);
    #enddo
    #do vv = 1,`$v'
      Fill,`$fb`vv'' = `$fr`vv'';
    #enddo
    On Parallel;
    On Statistics;
    Drop;
    Ndrop FF;
    Unhide FF;
    id	H(?a) = Hfill(?a);
	id	Hfill(?a) = H(?a);
    B+   E;
    .sort:substitution(`DEPTH'-`type')-{`$dcount'+1};
    Off Statistics;
	Hide FF;
  #else
    Off Statistics;
    Drop;
    Ndrop FF;
  #endif
  .sort
#endprocedure
*
*--#] clean : 
*--#[ solveshuffle :
*
#procedure solveshuffle
*
*	Procedure for stuffle equations for H in 1.
*   Apply shuffles and then let clean solve the equations.
*
  .sort
  InParallel;
  id,many,fun1?funs(?a) = 1;
  Transform,E,tointegralnotation(1,last);
  id  E(?a)*E(?b) = HH(?a)*HH(?b) - H(?a)*H(?b);
  Shuffle,H;
  .sort:Shuffling-`$count';
  InParallel;
  #call clean(sh)
#endprocedure
*
*--#] solveshuffle :
*--#[ solvestuffle :
*
#procedure solvestuffle
*
*	Procedure for stuffle equations for H in 1.
*   Apply stuffles (Z variety) and then let clean solve the equations.
*
  .sort
  InParallel;
  id,many,fun1?funs(?a) = 1;
  id  E(?a)*E(?b) = HH(?a)*HH(?b) - H(?a)*H(?b);
  Transform,HH,tointegralnotation(1,last);
  Stuffle,H+;
  .sort:Stuffling-`$count';
  InParallel;
  Transform,H,tointegralnotation(1,last);
  #call clean(st)
#endprocedure
*
*--#] solvestuffle : 
*--#[ duality :
*
#ifdef `OLDERDUALITY'
#procedure duality(H)
*
*   Applies duality on finite non-alternating H values in one
*
  repeat;
   if ( count(`H',1) );
*
*   First determine number of ones vs number of zeroes.
*   If the number of ones is greater than nargs/2 we must transform
*   If they are equal we should transform and determine the best.
*
    id,once,`H'(?a) = R1(?a)*R2(?a)*xx^nargs_(?a);
    #do i = `WEIGHT'^%,0,-1
        id  R2(x1?,...,x{2^`i'}?,?a) =
            R2(?a)*<x^x1>*...*<x^x{2^`i'}>;
    #enddo
    id  R2 = 1;
    if ( count(x,2,xx,-1) > 0 );
        Transform,R1,replace(1,last)=(0,1,1,0)
                    ,reverse(1,last);
        id  R1(?a) = R3(?a);
    elseif ( count(x,2,xx,-1) == 0 );
        id  R1(?a) = R1(?a)*R2(?a);
        Transform,R2,replace(1,last)=(0,1,1,0)
                    ,reverse(1,last);
        id  R2(?a) = R1(?a);
        id  R1(?a)*R1(?b) = R3(?a);
    else;
        id  R1(?a) = R3(?a);
    endif;
    id  xx^x?pos_ = 1;
    id  x^xx?pos_ = 1;
   endif;
  endrepeat;
  id  R3(?a) = `H'(?a);
#endprocedure
#else
#procedure duality(H)
*
*   Applies duality to finite non-alternating H values in one
*   Uses that weight = number of arguments in integral notation
*             depth  = number of arguments in sum notation
*   Assumes that the input is in integral notation.
*   The input may contain more than a single H.
*
  repeat;
   if ( count(`H',1) > 0 );
    id,once,`H'(?a) = R(?a)*R1(?a)*R2(nargs_(?a));
    Transform,R1,tosumnotation(1,last);
    id R1(?a)*R2(x?) = R2(x-2*nargs_(?a));
    if ( match(R2(x?pos_)) ); * weight > 2*depth
      id R(?a) = R3(?a);
    elseif ( match(R2(0)) );  * weight = 2*depth
      id R(?a) = R(?a)*R1(?a);
      Transform,R,reverse(1,last)
                 ,replace(1,last)=(0,1,1,0);
      id R(?a) = R1(?a);
      id R1(?a)*R1(?b) = R3(?a);
    else;       * Must replace. weight < 2*depth
      Transform,R,reverse(1,last)
                 ,replace(1,last)=(0,1,1,0);
      id R(?a) = R3(?a);
    endif;
    id R2(x?) = 1;
   endif;
  endrepeat;
  id R3(?a) = `H'(?a);
#endprocedure
#endif
*
*--#] duality : 
*--#[ makeHfinite :
*
#procedure makeHfinite
*
*   Extracts the divergent parts from a sum
*   These come from the shuffles with a single divergence.
*   We use single stuffles
*   Z(st(1,R(n,1)),m)+Z(R(n,1),m1,st(1,restofm)) = Z(1)*Z(R(n,1),m)
*   Z(R(n+1,1),m)*(n+1) + Z(stp(1,R(n,1),m)+Z(R(n,1),m1,st(1,restofm))
*            = Z(1)*Z(R(n,1),m)
*
*   This should eliminate all powers of Sinf
*	Once everything is correct, we just drop the powers of Sinf from the start.
*
id  H(1) = `SINF';
id  H(1,?a) = RR(Z(1,?a));
if ( count(RR,1) );
  label 1;
  Argument RR;
    Transform,Z,tosumnotation(1,last);
    if ( match(Z(1,1,?a)) );
        Multiply ZZZ;
        repeat id ZZZ(?a)*Z(1,?b) = ZZZ(?a,1)*Z(?b);
        id  ZZZ(1,?a)*Z(?b) = (`SINF'*Z(?a,?b)-Z(1)*Z(?a,?b)*ZZZ(1,?a))/(nargs_(?a)+1);
        Stuffle,Z+;
        id  ZZZ(?a)*Z(?a,?b) = 0;
        id  ZZZ(?a) = 1;
        id  Z = 1;
    else;
        id,Z(1,?a) = Za(1,?a)-Za(1)*Za(?a)+`SINF'*Za(?a);
        Stuffle,Za+;
        id  Za(?a) = Z(?a);
    endif;
  EndArgument;
  $Zdivcount = 0;
  Argument RR;
    if ( match(Z(1,?a)) ) $Zdivcount = 1;
  EndArgument;
  if ( $Zdivcount != 0 ) goto 1;
  Argument RR;
    Transform,Z,tointegralnotation(1,last);
    id  Z(?a) = H(?a);
  EndArgument;
  id  RR(x?) = x;
endif;
#endprocedure
*
*--#] makeHfinite : 
*--#[ convert :
*
#procedure convert(H,w,par)
#if ( `par' == 0 )
  Transform,`H',replace(1,last)=(0,1,1,0)
               ,encode(1,last):base=2;
#elseif ( `par' == 1 )
  Transform,`H',decode(1,`w'):base=2
               ,replace(1,`w')=(0,1,1,0);
#endif
#endprocedure
*
*--#] convert : 
*--#[ frombasis :
*
#procedure frombasis(WW)
*
#switch `WW'
#case 2
id	H(0,1) = z2;
#break
#case 3
id	H(0,0,1) = z3;
#break
#case 5
id	H(0,0,0,0,1) = z5;
#break
#case 7
id	H(0,0,0,0,0,0,1) = z7;
#break
#case 8
id	H(0,0,0,0,1,0,0,1) = z5z3;
#break
#case 9
id	H(0,0,0,0,0,0,0,0,1) = z9;
#break
#case 10
id	H(0,0,0,0,0,0,1,0,0,1) = z7z3;
*id	H(0,0,0,0,0,0,0,1,0,1) = z8z2;
#break
#case 11
id	H(0,0,0,0,0,0,0,0,0,0,1) = z11;
id	H(0,0,0,0,1,0,0,1,0,0,1) = z5z3z3;
#break
#case 12
id	H(0,0,0,0,0,0,0,0,1,0,0,1) = z9z3;
id	H(0,0,0,0,0,1,0,0,0,1,1,1) = z6z4z1z1;
#break
#case 13
id	H(0,0,0,0,0,0,0,0,0,0,0,0,1) = z13;
id	H(0,0,0,0,0,0,1,0,0,1,0,0,1) = z7z3z3;
id	H(0,0,0,0,1,0,0,0,0,1,0,0,1) = z5z5z3;
#break
#case 14
id	H(0,0,0,0,0,0,0,0,0,0,1,0,0,1) = z11z3;
id	H(0,0,0,0,0,0,0,0,1,0,0,0,0,1) = z9z5;
id	H(0,0,0,0,1,0,0,1,0,0,1,0,0,1) = z5z3z3z3;
#break
#case 15
id	H(0,0,0,0,0,0,0,0,0,0,0,0,0,0,1) = z15;
id	H(0,0,0,0,0,0,0,0,1,0,0,1,0,0,1) = z9z3z3;
id	H(0,0,0,0,0,0,1,0,0,0,0,1,0,0,1) = z7z5z3;
id  H(0,0,0,0,0,1,0,1,0,0,0,0,1,1,1) = z6z2z5z1z1;
#break
#case 16
id  H(0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1) = z13z3;
id  H(0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1) = z11z5;
id  H(0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,1) = z7z3z3z3;
id  H(0,0,0,0,1,0,0,0,0,1,0,0,1,0,0,1) = z5z5z3z3;
id  H(0,0,0,0,0,0,0,1,0,0,0,0,0,1,1,1) = z8z6z1z1;
#break
#case 17
id  H(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1) = z17;
id  H(0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1) = z11z3z3;
id  H(0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,1) = z9z5z3;
id  H(0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,1) = z9z3z5;
id  H(0,0,0,0,0,0,1,0,0,0,0,0,0,1,0,0,1) = z7z7z3;
id  H(0,0,0,0,1,0,0,1,0,0,1,0,0,1,0,0,1) = z5z3z3z3z3;
id  H(0,0,0,0,0,1,0,0,0,1,0,0,0,0,1,1,1) = z6z4z5z1z1;
#break
#case 18
id  H(0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1) = z15z3;
id  H(0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1) = z13z5;
id  H(0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,1) = z9z3z3z3;
id  H(0,0,0,0,0,0,1,0,0,0,0,1,0,0,1,0,0,1) = z7z5z3z3;
id  H(0,0,0,0,0,0,1,0,0,1,0,0,0,0,1,0,0,1) = z7z3z5z3;
id  H(0,0,0,0,1,0,0,0,0,1,0,0,0,0,1,0,0,1) = z5z5z5z3;
id  H(0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,1,1) = z10z6z1z1;
id  H(0,0,0,0,0,1,0,1,0,0,1,0,0,0,0,1,1,1) = z6z2z3z5z1z1;
#break
#case 19
id  H(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1) = z19;
id  H(0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1) = z13z3z3;
id  H(0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,1) = z11z5z3;
id  H(0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,1) = z11z3z5;
id  H(0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,0,0,1) = z9z7z3;
id  H(0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1) = z9z5z5;
id  H(0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,1,0,0,1) = z7z3z3z3z3;
id  H(0,0,0,0,1,0,0,0,0,1,0,0,1,0,0,1,0,0,1) = z5z5z3z3z3;
id  H(0,0,0,0,1,0,0,1,0,0,0,0,1,0,0,1,0,0,1) = z5z3z5z3z3;
id  H(0,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,1,1,1) = z6z6z5z1z1;
id  H(0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,1,1,1) = z8z2z7z1z1;
#break
#case 20
id  H(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1) = z17z3;
id  H(0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1) = z15z5;
id  H(0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1) = z13z7;
id  H(0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,1) = z11z3z3z3;
id  H(0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,1,0,0,1) = z9z5z3z3;
id  H(0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,1,0,0,1) = z9z3z5z3;
id  H(0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,1) = z9z3z3z5;
id  H(0,0,0,0,0,0,1,0,0,0,0,0,0,1,0,0,1,0,0,1) = z7z7z3z3;
id  H(0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1,0,0,1) = z7z5z5z3;
id  H(0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,1,1) = z10z8z1z1;
id  H(0,0,0,0,1,0,0,1,0,0,1,0,0,1,0,0,1,0,0,1) = z5z3z3z3z3z3;
id  H(0,0,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,1,1,1) = z6z4z3z5z1z1;
id  H(0,0,0,0,0,1,0,1,0,0,0,0,1,0,0,0,0,1,1,1) = z6z2z5z5z1z1;
#break
#case 21
id  H(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1) = z21;
id  H(0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1) = z15z3z3;
id  H(0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,1) = z13z5z3;
id  H(0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,1) = z13z3z5;
id  H(0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,0,0,1) = z11z7z3;
id  H(0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,1) = z11z3z7;
id  H(0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,1) = z9z9z3;
id  H(0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,1,0,0,1) = z9z3z3z3z3;
id  H(0,0,0,0,0,0,1,0,0,0,0,1,0,0,1,0,0,1,0,0,1) = z7z5z3z3z3;
id  H(0,0,0,0,0,0,1,0,0,1,0,0,0,0,1,0,0,1,0,0,1) = z7z3z5z3z3;
id  H(0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,1,0,0,1) = z7z3z3z5z3;
id  H(0,0,0,0,1,0,0,0,0,1,0,0,0,0,1,0,0,1,0,0,1) = z5z5z5z3z3;
id  H(0,0,0,0,1,0,0,0,0,1,0,0,1,0,0,0,0,1,0,0,1) = z5z5z3z5z3;
id  H(0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,1,1,1) = z10z4z5z1z1;
id  H(0,0,0,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,1,1,1) = z8z6z5z1z1;
id  H(0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,1,1,1) = z8z4z7z1z1;
id  H(0,0,0,0,0,1,0,1,0,0,1,0,0,1,0,0,0,0,1,1,1) = z6z2z3z3z5z1z1;
#break
#case 22
id  H(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1) = z19z3;
id  H(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1) = z17z5;
id  H(0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1) = z15z7;
id  H(0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,1) = z13z3z3z3;
id  H(0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,1,0,0,1) = z11z5z3z3;
id  H(0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,1,0,0,1) = z11z3z5z3;
id  H(0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,1) = z11z3z3z5;
id  H(0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,0,0,1,0,0,1) = z9z7z3z3;
id  H(0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1,0,0,1) = z9z5z5z3;
id  H(0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,1,0,0,0,0,1) = z9z5z3z5;
id  H(0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,1,0,0,1) = z9z3z7z3;
id  H(0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,1,0,0,0,0,1) = z9z3z5z5;
id  H(0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,1,0,0,1) = z7z5z7z3;
id  H(0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,1,1) = z12z8z1z1;
id  H(0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,1,0,0,1,0,0,1) = z7z3z3z3z3z3;
id  H(0,0,0,0,1,0,0,0,0,1,0,0,1,0,0,1,0,0,1,0,0,1) = z5z5z3z3z3z3;
id  H(0,0,0,0,1,0,0,1,0,0,0,0,1,0,0,1,0,0,1,0,0,1) = z5z3z5z3z3z3;
id  H(0,0,0,0,0,0,0,1,0,1,0,0,1,0,0,0,0,0,0,1,1,1) = z8z2z3z7z1z1;
id  H(0,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,1,0,0,1,1,1) = z6z6z5z3z1z1;
id  H(0,0,0,0,0,1,0,0,0,0,0,1,0,0,1,0,0,0,0,1,1,1) = z6z6z3z5z1z1;
id  H(0,0,0,0,0,1,0,0,0,1,0,0,0,0,1,0,0,0,0,1,1,1) = z6z4z5z5z1z1;
#break
#endswitch
*
#endprocedure
*
*--#] frombasis : 

