package nl.nikhef.slcshttps.gui;

import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JLabel;
import javax.swing.JPasswordField;


/**
 * Static class to get a password from the user via a popup window.
 * @author Mischa Sall&eacute;
 * @version 0.1
 */
public class PasswordPopup  {
    /**
     * Shows a password popup with given text as prompt and a {@link
     * JPasswordField}. Getting the default focus to the
     * <CODE>JPasswordField</CODE> component is done using {@link
     * GraphTools#optionPaneSetFocus(JComponent)}.
     * @param text prompt to show before the passwordfield
     * @return char[] representing the password
     * @see GraphTools#optionPaneSetFocus(JComponent)
     */
    public static char[] getPassword(String text)	{
	// Create passwordfield and prompt
	JPasswordField passwordField=new JPasswordField(10);
	JLabel label=new JLabel(text);
	// Create combined panel
	JPanel contentPanel=new JPanel();
	contentPanel.add(label);
	contentPanel.add(passwordField);
	// Set focus to passwordfield
	GraphTools.optionPaneSetFocus(passwordField);
	// Set options
	Object options[]={"OK"};
	// Create dialog
	JOptionPane.showOptionDialog(
	    null, // parent
	    contentPanel, // message
	    "Enter password", // title
	    JOptionPane.DEFAULT_OPTION, // optiontype
	    JOptionPane.PLAIN_MESSAGE, // messagetype
	    null, // icon
	    options, // options
	    options[0] // default option
	    );

        return passwordField.getPassword();
    }
}
