package nl.nikhef.slcshttps.gui;

import javax.swing.JOptionPane;
import nl.nikhef.slcshttps.trust.HttxURLConnection.HttxClientCommunicator;

/**
 * Implementation of <CODE>HttxURLConnection.HttxClientCommunicator</CODE> using
 * popup windows.
 * @author Mischa Sall&eacute;
 * @version 0.1
 * @see nl.nikhef.slcshttps.trust.HttxURLConnection.HttxClientCommunicator
 */
public class HttxClientPopupComm implements HttxClientCommunicator	{
    /**
     * Method to ask the user for confirmation to continue since the client
     * certificate has expired, using via a confirmation popup window.
     * @param mesg <CODE>String</CODE> containing a message describing the
     * problem.
     * @return boolean <CODE>true</CODE> when the user wants to continue,
     * <CODE>false</CODE> otherwise.
     */
    public boolean expired(String mesg)  {
	// First create a buffer with the correct text
	String buffer="<HTML><H3><FONT color=\"red\">"+
		      "<I>WARNING</I></FONT></H3>"+mesg+"<BR>&nbsp;</HTML>";
	// Create the JOptionPane
        Object options[]={"CONTINUE","CANCEL"};
        int returnVal=JOptionPane.showOptionDialog(
            null,
	    buffer,
            "Security problem",
            JOptionPane.OK_CANCEL_OPTION,
            JOptionPane.WARNING_MESSAGE,
            null,
            options,
            options[1]
            );
        if (returnVal==JOptionPane.OK_OPTION)
            return true;
        else
            return false;

    }
    
    /**
     * Method to inform the user that his client certificate is about to expire
     * using a popup window.
     * @param mesg <CODE>String</CODE> containing a message describing the
     * problem.
     */
    public void almostexpired(String mesg)  {
	// First create a buffer with the correct text
	String buffer="<HTML><H3><FONT color=\"red\">"+
		      "<I>WARNING</I></FONT></H3>"+mesg+"<BR>&nbsp;</HTML>";
	// Create the JOptionPane
        Object options[]={"OK"};
        int returnVal=JOptionPane.showOptionDialog(
            null,
	    buffer,
            "Security problem",
            JOptionPane.OK_OPTION,
            JOptionPane.WARNING_MESSAGE,
            null,
            options,
            options[0]
            );
    }
}


