package nl.nikhef.slcshttps;
// When using standalone, use instead:
// import nl.nikhef.slcshttps.SURFCAHttps;

import nl.nikhef.slcshttps.gui.SURFCAPopupComm;
import nl.nikhef.slcshttps.gui.CATool;
import nl.nikhef.slcshttps.gui.SURFCAInitDialog;

import nl.nikhef.slcshttps.SURFCAHttps;

import java.io.IOException;
import java.net.MalformedURLException;

import java.net.URL;
import javax.net.ssl.HttpsURLConnection;
import java.net.HttpURLConnection;
import java.security.cert.X509Certificate;
import javax.security.auth.x500.X500Principal;
import java.io.BufferedReader;
import java.io.InputStreamReader;

import nl.nikhef.slcshttps.trust.HttxURLConnection;

/**
 * Test class providing a {@link #main(String[])} method to test
 * {@link SURFCAHttps} and {@link PKCS12Https}.
 * It needs as command line argument an address will be be `dumped' using a
 * {@link HttpsURLConnection} using a client side certificate. Use for example
 * <P><CODE>"https://www.nikhef.nl/~msalle/cert/showcert.php?nohtml=1"</CODE>
 * <P>You will also need to set properties
 * {@value nl.nikhef.slcshttps.SURFCAHttps#CERT_URL_PROPERTY}
 * and {@value nl.nikhef.slcshttps.SURFCAHttps#AUTH_URL_PROPERTY}.
 * @see SURFCAHttps
 * @see PKCS12Https
 * @author Mischa Sall&eacute;
 * @version 0.2
 */
public class TestSURFCA {
    /**
     * Main method.
     * @param args <CODE>String[]</CODE>, command line argument, should be the
     * URL to dump to stdout
     * @see #dumpConnection(String)
     */
    public static void main(String[] args) {
	if (args.length!=1) {
	    System.err.println("Usage: TestSURFCA <URL>");
	    System.err.println("  use as URL e.g.: \"https://www.nikhef.nl/~msalle/cert/showcert.php?nohtml=1\"");
	    System.exit(1);
	}
	String URL=args[0];
	System.out.println("Starting...");

	// PKCS12
	PKCS12Https pkcs12CAHttps=null;
	try {
	    pkcs12CAHttps=new PKCS12Https();
	} catch(Exception e)	{
	    System.err.println("Exception: "+e.getMessage());
	    System.exit(1);
	}

	// SURFCA
	SURFCAHttps surfCAHttps=null;
	try { // initialize SURFCAHttps object
	    surfCAHttps=new SURFCAHttps();
	} catch (Exception e)	{
	    System.err.println("Exception:\n"+e.getMessage());
	    System.exit(1);
	}

	try{
//	    pkcs12CAHttps.initialize("/home/salle/usercert.p12","test");
//	    pkcs12CAHttps.initialize("/home/salle/imdi/usercert.p12","test");
	    pkcs12CAHttps.initialize();
	    pkcs12CAHttps.storeCertificate(true);
	} catch(Exception e)	{
	    System.err.println("Exception: "+e.getMessage());
	    System.exit(1);
	}

	// CAtool
	try {
	    CATool.showCATool(pkcs12CAHttps); // show CATool window: ca==null
	} catch(Exception e)	{
	    System.err.println("Exception: "+e.getMessage());
	    System.exit(1);
	}

	// SURFCA popups
	try { // authenticate (send CSR hash)
	    System.out.println("authenticate...");
	    surfCAHttps.initialize();
	} catch (Exception e)	{
	    System.err.println("Exception: "+e.getMessage());
	    System.exit(1);
	}
	try { // send CSR and get certificate
	    System.out.println("get certificate...");
	    surfCAHttps.storeCertificate();
	} catch (Exception e)	{
	    System.err.println("Exception: "+e.getMessage());
	    System.exit(1);
	}

	// CAtool
	try {
	    CATool.showCATool(surfCAHttps); // show CATool window: ca==uninit
	} catch(Exception e)	{
	    System.err.println("Exception: "+e.getMessage());
	    System.exit(1);
	}

	// SURFCA dialog: be careful, return value could be of type put in...
//	surfCAHttps=SURFCAInitDialog.getDialog((CAHttps)surfCAHttps);
	CAHttps newCAHttps=SURFCAInitDialog.getDialog((CAHttps)pkcs12CAHttps);
	if (newCAHttps instanceof SURFCAHttps)
	    surfCAHttps=(SURFCAHttps)newCAHttps;
	else	{
	    System.err.println("Returned object cannot be cast into SURFCAHttps");
	    System.exit(1);
	}
	
	// CAtool
	try {
	    CATool.showCATool(surfCAHttps); // show CATool window: ca==uninit
	} catch(Exception e)	{
	    System.err.println("Exception: "+e.getMessage());
	    System.exit(1);
	}

	try { // print connection
	    System.out.println("about to dump connection to: "+URL+" ...");
	    dumpConnection(URL);
	} catch (IOException e)	{
	    System.err.println("Exception: "+e.getMessage());
	    System.exit(1);
	}
    }

    /**
     * Helper method to open a {@link HttpsURLConnection} to
     * <CODE>stringURL</CODE> and dump the server response to stdout.
     * @param stringURL URL to connect to and dump
     * @throws IOException when reading goes wrong
     * @throws MalformedURLException when string doesn't denote a valid URL
     */
    private static void dumpConnection(String stringURL)
	throws IOException, MalformedURLException
    {
	URL url=null;
	try { // setup url
	    url=new URL(stringURL);
	} catch (MalformedURLException e)   {
	    System.err.println("Malformed URL: "+stringURL);
	    throw e;
	}
//	HttpsURLConnection connection=null;
	HttxURLConnection connection=null;
	try { // open connection
	    System.out.println("Opening connection...");
//	    connection=(HttpsURLConnection)url.openConnection();
	    connection=HttxURLConnection.openConnection(url);

	    System.out.println("Connecting connection: ");
	    connection.connect();
	} catch (IOException e) {
	    System.err.println("IOException: Cannot open connection to "+stringURL+"\n "+
//	    System.err.println("Cannot open connection to "+stringURL+"\n "+
		e.getMessage());
	    throw e;
	} catch (ClassCastException e)	{
	    System.err.println("Cannot open "+stringURL+" as https:\n "+
		e.getMessage());
	    throw new MalformedURLException("Cannot open "+stringURL+" as https");
	} catch (Exception e)	{
	    System.err.println("Cannot open connection to dump:\n "+
		e.getMessage());
	    throw new IOException("Cannot open connection to dump");
	}

	try { // get principal for SSL handshake
//	    Following two lines replies next, because JDK 1.4 doesn't have getPeerPrincipal(); Also, can then only get end-entitity certificate.
	    X509Certificate[] x509certs=(X509Certificate[])connection.getServerCertificates();
	    X509Certificate[] x509=new X509Certificate[x509certs.length-1];
	    for (int i=0; i<x509certs.length; i++)	{
		X500Principal princ=x509certs[i].getSubjectX500Principal();
		if (i<x509certs.length-1)
		    x509[i]=x509certs[i];
		System.out.println("Peer principal: "+princ.getName());
	    }
	} catch (Exception e)  {
	    connection.disconnect(); // cannot do in finally...
	    System.err.println("Cannot get Peer principal or its name");
	    throw new IOException("Cannot get Peer principal or its name");
	}
	BufferedReader reader=null;
	try { // get output
	    System.out.println("Starting to read...");
	    reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
	    System.out.println("BEGIN OF SERVER REPLY");
	    String line;
	    while ((line = reader.readLine()) != null)
		System.out.println(line);
	    System.out.println("END OF SERVER REPLY\n");
	} catch (IOException e)	{
	    System.err.println("Error reading: "+e.getMessage());
	    throw e;
	} finally {
	    if (reader!=null)   {
		reader.close(); reader=null;
	    }
	    connection.disconnect();
	}
    }
}
