package nl.nikhef.slcshttps.util;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.lang.reflect.InvocationTargetException;

import java.io.IOException;

/**
 * Static class providing tools for use with stdio/console.
 * @author Mischa Sall&eacute;
 * @version 0.1
 */
public class ConsoleTools   {
    /**
     * Reads and returns a line from the console (<CODE>System.in</CODE>).
     * @return the line read.
     * @throws IOException upon read error
     */
    public static String readLine() throws IOException {
	String string="";
	InputStreamReader inreader=null;
	BufferedReader bufreader=null;
	try {
	    inreader=new InputStreamReader(System.in);
	    bufreader=new BufferedReader(inreader);
	    string=bufreader.readLine();
	    // Note: don't close either bufreader or inreader, since that will
	    // close System.in...
	} catch(Exception e)    {
	    throw new IOException("Error reading from input stream");
	}
	return string;
    }
   
    /**
     * Provides a password prompt. For JDK1.6 and onwards we do this with
     * <CODE>java.io.Console.readPassword()</CODE>. For older versions we use
     * {@link PasswordReader}.
     * @param prompt <CODE>String</CODE> message printed before user input.
     * @return char[] with the password.
     * @throws IOException upon error.
     */
    public static char[] getPassword(String prompt) throws IOException   {
    try {
	    // Try finding java.io.Console
	    Class<?> console=Class.forName("java.io.Console");
	    // Need java.lang.System for its console() method
	    Class<?> system=Class.forName("java.lang.System");
	    // console() creates a Console object
	    Method getConsole=system.getDeclaredMethod("console", new Class[] {});
	    // create Console instance
	    Object consoleInstance=getConsole.invoke(null, new Object[] {});
	    // Find the readPassword method
	    Method readPassword=console.getDeclaredMethod("readPassword",new Class[]{});
	    System.out.println(prompt);
	    char[] password=(char[])readPassword.invoke(consoleInstance);
	    return password;
	} catch(InvocationTargetException e)	{
	    throw new IOException("Console error: "+e.getMessage());
	} catch(ClassNotFoundException e)   {
	    // this includes the absence of java desktop API
	} catch(Exception e) {
	    System.err.println("Warning: "+e.toString());
	}
	// We apparently don't have Console )-: Do it the dirty and old style... 

	return PasswordReader.getPassword(System.in, prompt);
    }

    /**
     * Confirmation from the user via console, returning true/false.
     * @param question <CODE>String</CODE> asked before user input.
     * @return boolean - <CODE>true</CODE> when user agrees.
     * @throws IOException upon error.
     */
    public static boolean getConfirm(String question) throws IOException   {
	boolean retVal=false;
	String answer=null;
	while (answer==null)    {
	    System.err.println(question+" (yes/no) ?");
	    answer=readLine().toLowerCase(); // throws IOException
	    if ("yes".equals(answer))	{
		retVal=true; break;
	    }
	    if ("no".equals(answer))	{
		retVal=false; break;
	    }
	    System.err.println("Please answer \"yes\" or \"no\"");
	    answer=null;
	}
	return retVal;
    }
}
