package nl.nikhef.slcshttps.gui;

import javax.swing.JOptionPane;
import nl.nikhef.slcshttps.trust.TrustManagerImpl.TrustCommunicator;

/**
 * Implementation of <CODE>TrustManagerImpl.TrustCommunicator</CODE> using popup
 * windows.
 * @author Mischa Sall&eacute;
 * @version 0.1
 * @see nl.nikhef.slcshttps.trust.TrustManagerImpl.TrustCommunicator
 */
public class TrustPopupComm implements TrustCommunicator	{
    /**
     * method to ask the user for confirmation via a confirmation popup window.
     * @param host <CODE>String</CODE> with the hostname to which an SSL is
     * being set up.
     * @param mesg <CODE>String</CODE> containing a message describing the
     * problem.
     * @param ques <CODE>String</CODE> containing a question asked to the
     * user just before user input.
     * @param errs <CODE>String</CODE> array with a list of errors.
     * @param olderrs <CODE>String</CODE> array with a list of errors when
     * this cert was seen previously.
     * @return boolean <CODE>true</CODE> when the user accepts it,
     * <CODE>false</CODE> when the user rejects it.
     */
    public boolean confirm(String host,String mesg,String ques,
			   String[] errs,String[] olderrs)  {

	// First create a buffer with the correct text
	StringBuffer buffer=new StringBuffer(
	    "<HTML><H3><FONT color=\"red\">"+
	    "Security problem while connecting to <I>"+host+
	    "</I></FONT></H3>");
	buffer.append(mesg+"<BR>");
	// Append old errors
	if (olderrs!=null)	{
	    buffer.append(
	       "You accepted this chain before for the following hosts/errors:"+
	       "<UL>");
	    for (int i=0; i<olderrs.length; i++)
		buffer.append("<LI>"+olderrs[i]);
	    buffer.append("</UL><P>");
	} else
	    buffer.append("<BR>");
	// Append new erros
	buffer.append("It has the following problem(s):"+
		      "<UL>");
	for (int i=0; i<errs.length; i++)
	    buffer.append("<LI><I>"+errs[i]+"</I>");
	buffer.append("</UL><P>"+ques+"?</HTML>");

	// Now create the JOptionPane
        Object options[]={"Accept","Cancel"};
        int returnVal=JOptionPane.showOptionDialog(
            null,
            buffer.toString(),
            "Security problem",
            JOptionPane.OK_CANCEL_OPTION,
            JOptionPane.WARNING_MESSAGE,
            null,
            options,
            options[1]
            );
        if (returnVal==JOptionPane.OK_OPTION)
            return true;
        else
            return false;

    }
}


