package nl.nikhef.slcshttps.gui;

import nl.nikhef.slcshttps.SURFCAHttps;
import nl.nikhef.slcshttps.SURFCAHttps.SURFCACommunicator;
import javax.swing.JOptionPane;

import java.io.IOException;

/**
 * Implementation of a {@link SURFCACommunicator} using popup windows instead of
 * the default {@link nl.nikhef.slcshttps.SURFCAHttps.StdioComm}. See {@link SURFCAHttps} for
 * details how this implementation is/can be used by setting the right system
 * property, by choosing the right constructor or set using method {@link
 * SURFCAHttps#setCommunicator(String)}.
 * @author Mischa Sall&eacute;
 * @version 0.1
 * @see SURFCACommunicator
 * @see SURFCAHttps#SURFCAHttps(SURFCACommunicator)
 */
public class SURFCAPopupComm implements SURFCACommunicator
{
    /** Text shown when the user is about to download his certificate. */
    private final String DOWNLOADTEXT="DOWNLOAD CERTIFICATE";

    /**
     * Called just before the webbrowser is started, prints an informative text
     * in a popup window and waits until the user confirms he is ready to start
     * the browser.
     * @throws IOException when poup window is closed prematurely.
     */
    public void preBrowse() throws IOException	{
	Object options[]={"START BROWSER"};
	int retVal=JOptionPane.showOptionDialog(
	    null,
	    "<html>A new webbrowser or webbrowsertab is about to start."+
	    "<P>&nbsp;<P>You will be asked to choose your "+
	    "Identity Provider and <I>log in</I>."+
	    "<P>&nbsp;"+
	    "<P><I><FONT color=\"red\">After</FONT></I> "+
	    "you are done, follow the instructions in the "+
	    "<I>new</I> popup window.</html>",
	    "Web Browser about to start",
	    JOptionPane.DEFAULT_OPTION,
	    JOptionPane.WARNING_MESSAGE,
	    null,
	    options,
	    options[0]
	);
	if (retVal==JOptionPane.CLOSED_OPTION)
	    throw new IOException("Browser startup cancelled"); 
    }
    
    /**
     * Called just after the webbrowser is started, prints a text in a popup
     * window and waits until the user confirms he is ready with the webbrowser.
     * @throws IOException when popup window is closed prematurely.
     */
    public void postBrowse() throws IOException	{
	Object options[]={DOWNLOADTEXT};
	int retVal=JOptionPane.showOptionDialog(
	    null,
	    "<html>When <I><FONT color=\"red\">finished </FONT>"+
	    "</I>in the webbrowser,"+
	    "<P>&nbsp;<P>press <I>"+DOWNLOADTEXT+"</I>."+
	    "<P>&nbsp;<P>This will download and install your "+
	    "Certificate</html>",
	    "Certificate download",
	    JOptionPane.DEFAULT_OPTION,
	    JOptionPane.WARNING_MESSAGE,
	    null,
	    options,
	    options[0]
	);
	if (retVal==JOptionPane.CLOSED_OPTION)
	    throw new IOException("Download cancelled"); 
    }

    /**
     * Called upon error, it opens an error popup window with an error message
     * using the text and {@link Exception#getMessage()} from <CODE>e</CODE> (if
     * non-null).
     * @param text <CODE>String</CODE> - some descriptive text.
     * @param e <CODE>Exception</CODE> that caused the error (if any).
     * @see GraphTools#errorPopup(String,Exception)
     */
    public void error(String text,Exception e) {
	GraphTools.errorPopup(text,e);
    }

    /**
     * Identical to {@link #error(String,Exception)} except that it is called
     * when an error occurs that might be fixed by the user. (S)He can then
     * choose to retry.
     * @param text <CODE>String</CODE> - some text.
     * @param e <CODE>Exception</CODE> that caused the error (if any).
     * @return boolean whether or not the user wishes to retry.
     * @see #error(String,Exception)
     * @see GraphTools#retryPopup(String,Exception)
     */
    public boolean retry(String text,Exception e) {
	return GraphTools.retryPopup(text,e);
    }

    /**
     * It is called when interaction has been successful and the certificate
     * stored, when {@link SURFCAHttps#getShowSuccess()} equals
     * <CODE>true</CODE>, it will then show a confirmation popup.
     * @param text <CODE>String</CODE> - text describing the certificate
     * subject.
     * @see GraphTools#successPopup(String)
     */
    public void success(String text) {
	if (SURFCAHttps.getShowSuccess())
	    GraphTools.successPopup("<html>Successfully imported certificate"+
				    "<P>&nbsp;<P>Subject information:"+
				    "<P><I>"+text+"</I></html>");
    }

}
