package nl.nikhef.slcshttps.gui;

import nl.nikhef.slcshttps.PKCS12Https;

import java.io.IOException;

/**
 * Implementation of <CODE>PKCS12Https.PKCS12Communicator</CODE> using popup
 * windows.
 * @author Mischa Sall&eacute;
 * @version 0.1
 * @see nl.nikhef.slcshttps.PKCS12Https.PKCS12Communicator
 */
public class PKCS12PopupComm implements PKCS12Https.PKCS12Communicator 	{
    /**
     * Method to get the PKCS12 password from the user, using a popup.
     * @param prompt <CODE>String</CODE> to print before input.
     * @return char[] representation of the password
     * @throws IOException upon I/O error
     * @see PasswordPopup
     */
    public char[] getPassword(String prompt)    {
	return PasswordPopup.getPassword(prompt);
    }

    /**
     * Method to get the PKCS12 filename from the user, using a popup. If
     * <CODE>path</CODE> is non-null it it used to start the file popup in,
     * otherwise the user default directory is used.
     * @param path <CODE>String</CODE> path to start in, use as offset. 
     * @return String representation of the absolute filename.
     * @throws IOException upon I/O error (including unreadability).
     * @see FilePopup
     */
    public String getFile(String path) throws IOException   {
	return FilePopup.getFile("p12","PKCS12 files","PKCS12 import",path);
    }

    /**
     * Called when an error occurs, showing a popup window with an error string
     * about the filename (if non-null) and the {@link Exception#getMessage()}
     * from <CODE>e</CODE> (when non-null).
     * @param fileName <CODE>String</CODE> describing the PKCS12 filename
     * which was tried.
     * @param e <CODE>Exception</CODE> that caused the error (if any).
     * @throws IOException with a (new) description of the problem
     * @see GraphTools#errorPopup(String,Exception)
     */
    public void error(String fileName, Exception e) throws IOException {
	GraphTools.errorPopup("Cannot import PKCS12 file <I>"+fileName+"</I>",e);
    }
   
    /**
     * Called when the PKCS12 file is successfully imported and the
     * certificate stored; when {@link #getShowSuccess()} equals
     * <CODE>true</CODE> it will show a confirmation popup.
     * @param fileName <CODE>String</CODE> describing the PKCS12 filename
     * which was imported.
     * @param subject <CODE>String</CODE> describing the Subject DN of the
     * certificate.
     * @see GraphTools#successPopup(String)
     */ 
    public void success(String fileName,String subject) {
	if (PKCS12Https.getShowSuccess())
	    GraphTools.successPopup("<html>Successfully imported PKCS12 file"+
		    "<P><I>"+fileName+"</I><P>&nbsp;"+
		    "<P>Subject information:<P><I>"+subject+"</I></html>");
    }
}
