package nl.nikhef.slcshttps.gui;

import javax.swing.table.DefaultTableModel;

/**
 * Class doing (almost) the same as {@link DefaultTableModel} except the default
 * is <EM>NOT</EM> to allow editing of the cells. Adapted from
 * <a href="http://isscvs.cern.ch/cgi-bin/viewcvs-all.cgi/DAQ/online/igui/src/igui/NonEditableDefaultTableModel.java?root=atlastdaq">Atlas DAQ IGUI</a>.
 * @author Mischa Sall&eacute;
 * @version 0.1
 * @see DefaultTableModel
 */
public class NonEditableDefaultTableModel extends DefaultTableModel {
    /**
     * Constructs a default <CODE>NonEditableDefaultTableModel</CODE>.
     */
    public NonEditableDefaultTableModel()   {
	super();
    }

    /**
     * Constructs a <CODE>NonEditableDefaultTableModel</CODE> with
     * <CODE>rowCount</CODE> rows and <CODE>columnCount</CODE> columns.
     * @param rowCount number of rows
     * @param columnCount number of columns
     */
    public NonEditableDefaultTableModel(int rowCount, int columnCount)	{
	super(rowCount, columnCount);
    }

    /**
     * Overwrites {@link DefaultTableModel#isCellEditable(int,int)}, always
     * returning false.
     * @param x column
     * @param y row
     * @return false
     */
    public boolean isCellEditable(int x, int y)    {
	return false;
    }
}
