package nl.nikhef.slcshttps.gui;

import javax.swing.JOptionPane;
import java.io.IOException;
import java.awt.GraphicsEnvironment;

import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.HierarchyListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

/**
 * Static class providing several static helper methods for user interaction via
 * a GUI, including popup methods for confirmation, errors etc.
 * @author Mischa Sall&eacute;
 * @version 0.1
 */
public class GraphTools  {
    /**
     * Shows an error message popup using given text (newlines replaced with
     * &lt;BR&gt;) and <CODE>Exception</CODE> (when non-null).
     * @param text text to print
     * @param e Exception which was caught: used in errormessage, not thrown.
     * @see #retryPopup(String,Exception)
     */
    public static void errorPopup(String text,Exception e) {
	Object options[]={"OK"};

	String textConverted=text.replace("\n","<BR>");
	String textBuffer;
	if (e==null)
	    textBuffer="<html><H3><FONT color=\"red\">ERROR</FONT></H3>"+
		       textConverted+"</html>";
	else
	    textBuffer="<html><H3><FONT color=\"red\">ERROR</FONT></H3>"+
		       textConverted+
		       "<P>&nbsp;<P><I>"+e.getMessage()+"</I></html>";

	JOptionPane.showOptionDialog(
	    null,
	    textBuffer,
	    "Error",
	    JOptionPane.DEFAULT_OPTION,
	    JOptionPane.ERROR_MESSAGE,
	    null,
	    options,
	    options[0]
	);
    }

    /**
     * Shows an error message popup using given text (newlines replaced with
     * &lt;BR&gt;).
     * @param text text to print
     * @see #errorPopup(String,Exception)
     * @see #retryPopup(String)
     */
    public static void errorPopup(String text) {
	errorPopup(text,null);
    }

    /**
     * Shows an error message popup using given text (newlines replaced with
     * &lt;BR&gt;) and <CODE>Exception</CODE> (when non-null) giving the user
     * the option to choose to retry.
     * @param text text to print
     * @param e Exception which was caught: used in errormessage, not thrown.
     * @return boolean <CODE>true</CODE> indicating whether to retry.
     * @see #errorPopup(String,Exception)
     */
    public static boolean retryPopup(String text,Exception e)  {
	Object options[]={"RETRY","CANCEL"};

	String textConverted=text.replace("\n","<BR>");
	String textBuffer;
	if (e==null)
	    textBuffer="<html><H3><FONT color=\"red\">ERROR</FONT></H3>"+
		       textConverted+"</html>";
	else
	    textBuffer="<html><H3><FONT color=\"red\">ERROR</FONT></H3>"+
		       textConverted+
		       "<P>&nbsp;<P><I>"+e.getMessage()+"</I></html>";

	int returnVal=JOptionPane.showOptionDialog(
	    null,
	    textBuffer,
	    "Error",
	    JOptionPane.DEFAULT_OPTION,
	    JOptionPane.ERROR_MESSAGE,
	    null,
	    options,
	    options[0]
	);
	if (returnVal==JOptionPane.OK_OPTION)
	    return true;
	else
	    return false;
    }
    
    /**
     * Shows an error message popup using given text (newlines replaced with
     * &lt;BR&gt;) giving the user the option to choose to retry.
     * @param text text to print
     * @return boolean <CODE>true</CODE> indicating whether to retry.
     * @see #errorPopup(String)
     * @see #retryPopup(String,Exception)
     */
    public static boolean retryPopup(String text) {
	return retryPopup(text,null);
    }

    /**
     * Shows a success message popup using given text.
     * @param text text to print
     */
    public static void successPopup(String text) {
	Object options[]={"OK"};
	JOptionPane.showOptionDialog(
	    null,
	    text,
	    "Success",
	    JOptionPane.DEFAULT_OPTION,
	    JOptionPane.INFORMATION_MESSAGE,
	    null,
	    options,
	    options[0]
	);
    }
    
    /**
     * Shows a confirm (OK / cancel) popup.
     * @param text text to print
     * @return boolean which is <CODE>true</CODE> upon confirmation.
     */
    public static boolean confirmPopup(String text) {
	Object options[]={"Confirm","Cancel"};
	int returnVal=JOptionPane.showOptionDialog(
	    null,
	    text,
	    "Need confirmation",
	    JOptionPane.OK_CANCEL_OPTION,
	    JOptionPane.QUESTION_MESSAGE,
	    null,
	    options,
	    options[1]
	    );
	if (returnVal==JOptionPane.OK_OPTION)
	    return true;
	else
	    return false;

    }

    /**
     * Method to determine if a GUI is available. Works cross-platform (e.g.
     * Linux and MacOS). Note that {@link
     * java.awt.GraphicsEnvironment#isHeadless()} is insufficient.
     * @return boolean indicating whether a GUI is available
     * @see GraphicsEnvironment#getLocalGraphicsEnvironment()
     * @see GraphicsEnvironment#getDefaultScreenDevice()()
     */
    public static boolean isGraphic()	{
	try {
	    // We need both, we can know about graphics but not be able to use
	    // it or not know about it. isHeadless() is not good enough!
	    GraphicsEnvironment ge=GraphicsEnvironment.getLocalGraphicsEnvironment();
	    ge.getDefaultScreenDevice();
	    return true;
	} catch (Error e)	{
	    return false;
	} catch (Exception e)	{
	    return false;
	}
    }

    /**
     * Helper method to set the focus component of a {@link JOptionPane}.
     * <p>See explanation in
     * <a href="http://bugs.sun.com/bugdatabase/view_bug.do?bug_id=5018574">Java bug 5018574</a>
     * @param c <CODE>JComponent</CODE> to give the focus.
     * @see PasswordPopup
     */
    protected static void optionPaneSetFocus(JComponent c) {
	c.addHierarchyListener(new HierarchyListener() {
	    public void hierarchyChanged(HierarchyEvent e) {
		final Component c = e.getComponent();
		if (c.isShowing() && 
		    (e.getChangeFlags() & HierarchyEvent.SHOWING_CHANGED) != 0)
		{
		    Window toplevel = SwingUtilities.getWindowAncestor(c);
		    toplevel.addWindowFocusListener(new WindowAdapter() {
			@Override
			public void windowGainedFocus(WindowEvent e) {
			    c.requestFocus();
			}
		    });
		}
	    }
	});
    }
}

