package nl.nikhef.slcshttps.gui;

import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

import java.io.IOException;

/**
 * Static class to let the user choose a file using a {@link JFileChooser}.
 * @author Mischa Sall&eacute;
 * @version 0.1
 */
public class FilePopup	{
    /**
     * Shows a file chooser popup window ({@link JFileChooser}) in the default
     * directory for the user.
     * @param ext filename extension to filter with, case insensitive
     * @param extName text describing the filename extension
     * @param title popup title
     * @return String describing the full path of the chosen file (can be
     * <CODE>null</CODE>)
     * @throws IOException upon failure, including an unreadable file
     * @see #getFile(String,String,String,String)
     */
    public static String getFile(String ext, String extName, String title)
	throws IOException
    {
	return getFile(ext,extName,title,null);
    }

    /**
     * Shows a file chooser popup window ({@link JFileChooser}) in the specified
     * directory.
     * @param ext filename extension to filter with, case insensitive
     * @param extName text describing the filename extension
     * @param title popup title
     * @param dir starting directory, when <CODE>null</CODE> use default for the
     * user.
     * @return String describing the full path of the chosen file (can be
     * <CODE>null</CODE>)
     * @throws IOException upon failure, including an unreadable file
     */
    public static String getFile(String ext, String extName, String title, String dir)
	throws IOException
    {
	// Create a JFileChooser
	JFileChooser fc = new JFileChooser();
	fc.setMultiSelectionEnabled(false); // don't allow multi
	fc.setDialogTitle(title);
	if (dir!=null)
	    fc.setCurrentDirectory(new File(dir));
	// Setup the filename filter
	FileFilter filter = new FileNameExtFilter(extName, ext);
	fc.addChoosableFileFilter(filter);
	int returnVal = fc.showOpenDialog(null);
	// What has been chosen?
	if (returnVal == JFileChooser.APPROVE_OPTION) {
	    File file = fc.getSelectedFile();
	    if (file.canRead())
		return file.getAbsolutePath();
	    else
		throw new IOException("Cannot read "+file.getAbsolutePath());
	} else
	    return null;
    }
}
