package nl.nikhef.slcshttps.gui;

import javax.swing.JOptionPane;
import java.security.KeyStoreException;

import nl.nikhef.slcshttps.CAHttps;

/**
 * Static class to show a {@link CAPanel} in a popup window; this contains
 * information about the {@link CAHttps}.
 * @author Mischa Sall&eacute;
 * @version 0.1
 * @see CAPanel
 * @see CAHttps
 */
public class CATool {
    /**
     * static method showing a popup containing a {@link CAPanel} for given
     * <CODE>caHttps</CODE>. If the <CODE>CAPanel</CODE> cannot be created a
     * error is shown.
     * @param caHttps used to get all information from.
     * @throws Exception in case of error.
     */
    public static void showCATool(CAHttps caHttps) throws Exception {
	CAPanel caPanel;
	Object options[]={"Close"}; // Text on the OK button

	try {
	    caPanel=new CAPanel(caHttps);
	    JOptionPane.showOptionDialog(
		null,			    // parent
		caPanel,		    // contents
		"Certificate Info",	    // title
		JOptionPane.DEFAULT_OPTION, // type of buttons
		JOptionPane.PLAIN_MESSAGE,  // type of message
		null,			    // icon
		options,		    // options (buttons)
		options[0]		    // default option (button)
	    );
	} catch (KeyStoreException e)	{
	    try {
		// In case of keystore exception, we can give feedback
		GraphTools.errorPopup("Cannot get information from CAHttps",e);
	    } catch(Exception f)  {
		// Might be we don't have graphics...
		throw f;
	    }
	}
    }
}
