/*
 * Decompiled with CFR 0.152.
 */
package nl.nikhef.slcshttps;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.net.ssl.HttpsURLConnection;

public class CAConnection {
    private HttpsURLConnection connection = null;
    private int responseCode = 0;
    private String responseMessage = "";
    private StringBuffer response = null;
    protected final String POST_CONTENT_TYPE = "application/x-www-form-urlencoded";
    protected final String RESP_CONTENT_TYPE = "application/pkix-cert";

    public CAConnection() throws IOException {
        this(null);
    }

    public CAConnection(String string) throws IOException {
        if (string == null || string == "") {
            throw new IOException("Cannot open empty url");
        }
        try {
            URL uRL = new URL(string);
            this.connection = (HttpsURLConnection)uRL.openConnection();
            this.connection.setInstanceFollowRedirects(false);
            uRL = null;
        }
        catch (Exception exception) {
            throw new IOException("Cannot open url " + string + ": " + exception.getMessage());
        }
    }

    public int postString(String string) throws IOException {
        this.responseCode = 0;
        OutputStream outputStream = null;
        OutputStreamWriter outputStreamWriter = null;
        try {
            this.connection.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
            this.connection.setDoOutput(true);
            outputStream = this.connection.getOutputStream();
        }
        catch (Exception exception) {
            throw new IOException("Cannot get an output connection to the CA: " + exception.getMessage());
        }
        try {
            outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
            outputStreamWriter.write(string);
        }
        catch (Exception exception) {
            throw new IOException("Failure to post data to CA: " + exception.getMessage());
        }
        finally {
            if (outputStreamWriter != null) {
                outputStreamWriter.close();
                outputStreamWriter = null;
            }
        }
        try {
            this.responseCode = this.connection.getResponseCode();
            this.responseMessage = this.connection.getResponseCode() + " " + this.connection.getResponseMessage();
        }
        catch (Exception exception) {
            throw new IOException("Failure to get response code from CA: " + exception.getMessage());
        }
        return this.responseCode;
    }

    public X509Certificate getCert() throws CertificateException, IOException {
        X509Certificate x509Certificate = null;
        if (!this.connection.getHeaderField("Content-type").equals("application/pkix-cert")) {
            this.storeResponse();
            throw new CertificateException("Server didn't return a valid certificate");
        }
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509", "BC");
            InputStream inputStream = this.connection.getInputStream();
            x509Certificate = (X509Certificate)certificateFactory.generateCertificate(inputStream);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new CertificateException("Problem converting server output into X509Certificate", noSuchProviderException);
        }
        catch (CertificateException certificateException) {
            throw new CertificateException("Problem converting server output into X509Certificate", certificateException);
        }
        catch (IOException iOException) {
            throw new IOException("Error reading response from server: " + iOException.getMessage());
        }
        catch (Exception exception) {
            throw new IOException("Unknown error reading response from server: " + exception.getMessage());
        }
        return x509Certificate;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public String getResponseMessage() {
        return this.responseMessage;
    }

    public String getResponse() {
        if (this.response == null) {
            return "";
        }
        return this.response.toString();
    }

    private int storeResponse() throws IOException {
        BufferedReader bufferedReader = null;
        this.response = new StringBuffer();
        int n = 0;
        try {
            String string;
            InputStream inputStream = this.connection.getInputStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            bufferedReader = new BufferedReader(inputStreamReader);
            while ((string = bufferedReader.readLine()) != null) {
                this.response.append(string + "\n");
                ++n;
            }
        }
        catch (Exception exception) {
            throw new IOException("Cannot store data from connection into response field: " + exception.getMessage());
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
                bufferedReader = null;
            }
        }
        return n;
    }
}

